/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.parser.FixedWidthSchema;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.KeyValPair;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.annotations.VisibleForTesting;
import com.univocity.parsers.fixed.FieldAlignment;
import com.univocity.parsers.fixed.FixedWidthFields;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedWidthParser
extends Parser<byte[], KeyValPair<String, String>>
implements Operator.ActivationListener<Context> {
    private static final Logger logger = LoggerFactory.getLogger(FixedWidthParser.class);
    public final transient DefaultOutputPort<HashMap<String, Object>> parsedOutput = new DefaultOutputPort();
    @AutoMetric
    private long parsedOutputCount;
    @NotNull
    private String jsonSchema;
    private int recordLength;
    private transient FixedWidthSchema schema;
    private transient List<TypeInfo> setters;
    private transient String header;
    private com.univocity.parsers.fixed.FixedWidthParser univocityParser;

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.parsedOutputCount = 0L;
    }

    public void processTuple(byte[] tuple) {
        if (tuple == null) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair(null, (Object)"Blank/null tuple"));
                logger.error("Tuple could not be parsed. Reason Blank/null tuple");
            }
            ++this.errorTupleCount;
            return;
        }
        String incomingString = new String(tuple);
        if (StringUtils.isBlank((String)incomingString) || StringUtils.equals((String)incomingString, (String)this.getHeader())) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)"Blank/header tuple"));
                logger.error("Tuple could not be parsed. Reason Blank/header tuple");
            }
            ++this.errorTupleCount;
            return;
        }
        if (incomingString.length() < this.recordLength) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)"Record length mis-match/shorter tuple"));
            }
            logger.error("Tuple could not be parsed. Reason Record length mis-match/shorter tuple. Expected length " + this.recordLength + " Actual length " + incomingString.length());
            ++this.errorTupleCount;
            return;
        }
        if (incomingString.length() > this.recordLength) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)"Record length mis-match/longer tuple"));
            }
            logger.error("Tuple could not be parsed. Reason Record length mis-match/longer tuple. Expected length " + this.recordLength + " Actual length " + incomingString.length());
            ++this.errorTupleCount;
            return;
        }
        try {
            String[] values = this.univocityParser.parseLine(incomingString);
            HashMap toEmit = new HashMap();
            Object pojo = this.validateAndSet(values, toEmit);
            if (this.parsedOutput.isConnected()) {
                this.parsedOutput.emit(toEmit);
                ++this.parsedOutputCount;
            }
            if (this.out.isConnected() && this.clazz != null) {
                this.out.emit(pojo);
                ++this.emittedObjectCount;
            }
        }
        catch (Exception e) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)e.getMessage()));
            }
            ++this.errorTupleCount;
            logger.error("Tuple could not be parsed. Reason {}", (Object)e.getMessage());
        }
    }

    public KeyValPair<String, String> processErrorTuple(byte[] input) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Object convert(byte[] tuple) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setup(Context.OperatorContext context) {
        try {
            this.schema = new FixedWidthSchema(this.jsonSchema);
            this.recordLength = 0;
            List<FixedWidthSchema.Field> fields = this.schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                this.recordLength += fields.get(i).getFieldLength();
            }
            this.createUnivocityParser();
        }
        catch (Exception e) {
            logger.error("Cannot setup Parser Reason {}", (Object)e.getMessage());
            throw e;
        }
    }

    public void activate(Context context) {
        try {
            if (this.clazz != null) {
                this.setters = new ArrayList<TypeInfo>();
                List<String> fieldNames = this.schema.getFieldNames();
                if (fieldNames != null) {
                    for (String fieldName : fieldNames) {
                        this.addSetter(fieldName);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Cannot activate Parser Reason {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void createUnivocityParser() {
        List<FixedWidthSchema.Field> fields = this.schema.getFields();
        FixedWidthFields fieldWidthFields = new FixedWidthFields(new int[0]);
        for (int i = 0; i < fields.size(); ++i) {
            FixedWidthSchema.Field currentField = fields.get(i);
            int fieldLength = currentField.getFieldLength();
            FieldAlignment currentFieldAlignment = currentField.getAlignment().equalsIgnoreCase("centre") ? FieldAlignment.CENTER : (currentField.getAlignment().equalsIgnoreCase("left") ? FieldAlignment.LEFT : FieldAlignment.RIGHT);
            fieldWidthFields.addField(currentField.getName(), fieldLength, currentFieldAlignment, currentField.getPadding());
        }
        FixedWidthParserSettings settings = new FixedWidthParserSettings(fieldWidthFields);
        this.univocityParser = new com.univocity.parsers.fixed.FixedWidthParser(settings);
    }

    public void deactivate() {
    }

    private void addSetter(String fieldName) {
        try {
            Field f = this.clazz.getDeclaredField(fieldName);
            TypeInfo t = new TypeInfo(f.getName(), ClassUtils.primitiveToWrapper(f.getType()));
            t.setter = PojoUtils.createSetter((Class)this.clazz, (String)t.name, (Class)t.type);
            this.setters.add(t);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field " + fieldName + " not found in class " + this.clazz, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while adding a setter" + e.getMessage(), e);
        }
    }

    private Object validateAndSet(String[] values, HashMap toEmit) {
        Object pojoObject = null;
        try {
            List<FixedWidthSchema.Field> fields = this.schema.getFields();
            try {
                if (this.clazz != null) {
                    pojoObject = this.clazz.newInstance();
                }
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Exception in instantiating", ie);
            }
            for (int i = 0; i < fields.size(); ++i) {
                FixedWidthSchema.Field currentField = fields.get(i);
                TypeInfo typeInfo = this.setters.get(i);
                this.validateAndSetCurrentField(currentField, values[i], typeInfo, pojoObject, toEmit);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("Record length and tuple length mismatch ", e);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException("Illegal Access ", ie);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in validation", e);
        }
        return pojoObject;
    }

    private void validateAndSetCurrentField(FixedWidthSchema.Field currentField, String value, TypeInfo typeInfo, Object pojoObject, HashMap toEmit) {
        try {
            String fieldName = currentField.getName();
            if (value != null && !value.isEmpty()) {
                Object result;
                switch (currentField.getType()) {
                    case INTEGER: {
                        result = Integer.parseInt(value);
                        break;
                    }
                    case DOUBLE: {
                        result = Double.parseDouble(value);
                        break;
                    }
                    case STRING: {
                        result = value;
                        break;
                    }
                    case CHARACTER: {
                        result = Character.valueOf(value.charAt(0));
                        break;
                    }
                    case FLOAT: {
                        result = Float.valueOf(Float.parseFloat(value));
                        break;
                    }
                    case LONG: {
                        result = Long.parseLong(value);
                        break;
                    }
                    case SHORT: {
                        result = Short.parseShort(value);
                        break;
                    }
                    case BOOLEAN: {
                        if (value.compareToIgnoreCase(currentField.getTrueValue()) == 0) {
                            result = Boolean.parseBoolean("true");
                            break;
                        }
                        if (value.compareToIgnoreCase(currentField.getFalseValue()) == 0) {
                            result = Boolean.parseBoolean("false");
                            break;
                        }
                        throw new NumberFormatException();
                    }
                    case DATE: {
                        SimpleDateFormat df = new SimpleDateFormat(currentField.getDateFormat());
                        df.setLenient(false);
                        result = df.parse(value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid Type in Field", new Exception());
                    }
                }
                toEmit.put(fieldName, result);
                if (typeInfo != null && pojoObject != null) {
                    typeInfo.setter.set(pojoObject, result);
                }
            } else {
                toEmit.put(fieldName, value);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing" + value + " to Integer type", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing" + value, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting " + value + " in the given class" + typeInfo.toString(), e);
        }
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @VisibleForTesting
    public long getErrorTupleCount() {
        return this.errorTupleCount;
    }

    @VisibleForTesting
    public long getEmittedObjectCount() {
        return this.emittedObjectCount;
    }

    @VisibleForTesting
    public long getIncomingTuplesCount() {
        return this.incomingTuplesCount;
    }

    @VisibleForTesting
    public long getParsedOutputCount() {
        return this.parsedOutputCount;
    }

    static class TypeInfo {
        String name;
        Class type;
        PojoUtils.Setter setter;

        public TypeInfo(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "'name': " + this.name + " 'type': " + this.type;
        }
    }
}

