/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.contrib.parser.Schema;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedWidthSchema
extends Schema {
    public static final String FIELD_LENGTH = "length";
    public static final String FIELD_PADDING_CHARACTER = "padding";
    public static final char DEFAULT_PADDING_CHARACTER = ' ';
    public static final String DEFAULT_ALIGNMENT = "left";
    public static final String FIELD_ALIGNMENT = "alignment";
    public static final Logger logger = LoggerFactory.getLogger(FixedWidthSchema.class);
    private List<Field> fields = new LinkedList<Field>();
    private char globalPadding;
    private String globalAlignment;

    public FixedWidthSchema(String json) {
        try {
            this.initialize(json);
        }
        catch (IOException | JSONException e) {
            logger.error("{}", e);
            throw new IllegalArgumentException(e);
        }
    }

    public char getGlobalPadding() {
        return this.globalPadding;
    }

    public void setGlobalPadding(char padding) {
        this.globalPadding = padding;
    }

    public String getGlobalAlignment() {
        return this.globalAlignment;
    }

    public void setGlobalAlignment(String globalAlignment) {
        this.globalAlignment = globalAlignment;
    }

    private void initialize(String json) throws JSONException, IOException {
        JSONObject jo = new JSONObject(json);
        JSONArray fieldArray = jo.getJSONArray("fields");
        this.globalPadding = jo.has(FIELD_PADDING_CHARACTER) ? jo.getString(FIELD_PADDING_CHARACTER).charAt(0) : (char)32;
        this.globalAlignment = jo.has(FIELD_ALIGNMENT) ? jo.getString(FIELD_ALIGNMENT) : DEFAULT_ALIGNMENT;
        for (int i = 0; i < fieldArray.length(); ++i) {
            JSONObject obj = fieldArray.getJSONObject(i);
            Field field = new Field(obj.getString("name"), obj.getString("type").toUpperCase(), obj.getInt(FIELD_LENGTH));
            if (obj.has(FIELD_PADDING_CHARACTER)) {
                field.setPadding(obj.getString(FIELD_PADDING_CHARACTER).charAt(0));
            } else {
                field.setPadding(this.globalPadding);
            }
            if (obj.has(FIELD_ALIGNMENT)) {
                field.setAlignment(obj.getString(FIELD_ALIGNMENT));
            } else {
                field.setAlignment(this.globalAlignment);
            }
            if (field.getType() == Schema.FieldType.DATE) {
                if (obj.has("format")) {
                    field.setDateFormat(obj.getString("format"));
                } else {
                    field.setDateFormat("dd/mm/yy");
                }
            }
            if (field.getType() == Schema.FieldType.BOOLEAN) {
                if (obj.has("trueValue")) {
                    field.setTrueValue(obj.getString("trueValue"));
                } else {
                    field.setTrueValue("true");
                }
                if (obj.has("falseValue")) {
                    field.setFalseValue(obj.getString("falseValue"));
                } else {
                    field.setFalseValue("false");
                }
            }
            this.fields.add(field);
            this.fieldNames.add(field.name);
        }
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public class Field
    extends Schema.Field {
        private int fieldLength;
        private String dateFormat;
        private String trueValue;
        private String falseValue;
        private char padding;
        private String alignment;

        public Field(String name, String type, Integer fieldLength) {
            super(FixedWidthSchema.this, name, type);
            this.fieldLength = fieldLength;
            this.dateFormat = "dd/mm/yy";
            this.trueValue = "true";
            this.falseValue = "false";
            this.padding = (char)32;
            this.alignment = FixedWidthSchema.DEFAULT_ALIGNMENT;
        }

        public int getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(Integer fieldLength) {
            this.fieldLength = fieldLength;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getTrueValue() {
            return this.trueValue;
        }

        public void setTrueValue(String trueValue) {
            this.trueValue = trueValue;
        }

        public String getFalseValue() {
            return this.falseValue;
        }

        public void setFalseValue(String falseValue) {
            this.falseValue = falseValue;
        }

        public char getPadding() {
            return this.padding;
        }

        public void setPadding(char padding) {
            this.padding = padding;
        }

        public String getAlignment() {
            return this.alignment;
        }

        public void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public String toString() {
            return "Fields [name=" + this.name + ", type=" + (Object)((Object)this.type) + " fieldLength= " + this.fieldLength + "]";
        }
    }
}

