/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.parser.DelimitedSchema;
import com.datatorrent.contrib.parser.Schema;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.KeyValPair;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class RegexParser
extends Parser<byte[], KeyValPair<String, String>> {
    @NotNull
    private String schema;
    private transient DelimitedSchema delimitedParserSchema;
    @NotNull
    private String splitRegexPattern;
    private transient Pattern pattern;
    private static final Logger logger = LoggerFactory.getLogger(RegexParser.class);

    public void setup(Context.OperatorContext context) {
        this.delimitedParserSchema = new DelimitedSchema(this.schema);
        this.pattern = Pattern.compile(this.splitRegexPattern);
    }

    public void processTuple(byte[] tuple) {
        if (tuple == null) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair(null, (Object)"Blank/null tuple"));
            }
            ++this.errorTupleCount;
            return;
        }
        String incomingString = new String(tuple);
        if (StringUtils.isBlank((String)incomingString)) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)"Blank tuple"));
            }
            ++this.errorTupleCount;
            return;
        }
        try {
            if (this.out.isConnected() && this.clazz != null) {
                Matcher matcher = this.pattern.matcher(incomingString);
                boolean patternMatched = false;
                Constructor ctor = this.clazz.getConstructor(new Class[0]);
                Object object = ctor.newInstance(new Object[0]);
                if (matcher.find()) {
                    for (int i = 0; i <= matcher.groupCount() - 1; ++i) {
                        if (this.delimitedParserSchema.getFields().get(i).getType() == Schema.FieldType.DATE) {
                            DateConverter dtConverter = new DateConverter();
                            dtConverter.setPattern((String)this.delimitedParserSchema.getFields().get(i).getConstraints().get("format"));
                            ConvertUtils.register((Converter)dtConverter, Date.class);
                        }
                        BeanUtils.setProperty(object, (String)this.delimitedParserSchema.getFields().get(i).getName(), (Object)matcher.group(i + 1));
                    }
                    patternMatched = true;
                }
                if (!patternMatched) {
                    throw new ConversionException("The incoming tuple do not match with the Regex pattern defined.");
                }
                this.out.emit(object);
                ++this.emittedObjectCount;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ConversionException e) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)e.getMessage()));
                logger.debug("Regex Expression : {} Incoming tuple : {}", (Object)this.splitRegexPattern, (Object)incomingString);
            }
            ++this.errorTupleCount;
            logger.error("Tuple could not be parsed. Reason {}", (Object)e.getMessage());
        }
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSplitRegexPattern(String splitRegexPattern) {
        this.splitRegexPattern = splitRegexPattern;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSplitRegexPattern() {
        return this.splitRegexPattern;
    }

    public Object convert(byte[] tuple) {
        throw new UnsupportedOperationException("Not supported");
    }

    public KeyValPair<String, String> processErrorTuple(byte[] input) {
        throw new UnsupportedOperationException("Not supported");
    }

    @VisibleForTesting
    public long getErrorTupleCount() {
        return this.errorTupleCount;
    }

    @VisibleForTesting
    public long getEmittedObjectCount() {
        return this.emittedObjectCount;
    }

    @VisibleForTesting
    public long getIncomingTuplesCount() {
        return this.incomingTuplesCount;
    }
}

