/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.r;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.r.REngineConnectable;
import com.datatorrent.lib.util.BaseNumberValueOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.rosuda.REngine.REngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMin<V extends Number>
extends BaseNumberValueOperator<Number>
implements Operator.Unifier<Number> {
    private List<Number> numList = new ArrayList<Number>();
    REngineConnectable connectable;
    private static Logger log = LoggerFactory.getLogger(RMin.class);
    public final transient DefaultInputPort<Number> data = new DefaultInputPort<Number>(){

        public void process(Number tuple) {
            RMin.this.process(tuple);
        }
    };
    public final transient DefaultOutputPort<Number> min = new DefaultOutputPort<Number>(){

        public Operator.Unifier<Number> getUnifier() {
            return RMin.this;
        }
    };

    public void process(Number tuple) {
        this.numList.add(tuple);
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.connectable = new REngineConnectable();
            this.connectable.connect();
        }
        catch (IOException ioe) {
            log.error("Exception: ", (Throwable)ioe);
            DTThrowable.rethrow((Exception)ioe);
        }
    }

    public void teardown() {
        try {
            this.connectable.disconnect();
        }
        catch (IOException ioe) {
            log.error("Exception: ", (Throwable)ioe);
            DTThrowable.rethrow((Exception)ioe);
        }
    }

    public void endWindow() {
        if (this.numList.size() == 0) {
            return;
        }
        double[] values = new double[this.numList.size()];
        for (int i = 0; i < this.numList.size(); ++i) {
            values[i] = this.numList.get(i).doubleValue();
        }
        try {
            this.connectable.getRengine().assign("numList", values);
        }
        catch (REngineException e) {
            log.error("Exception: ", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        double rMin = 0.0;
        try {
            rMin = this.connectable.getRengine().parseAndEval("min(numList)").asDouble();
            this.connectable.getRengine().parseAndEval("rm(list = setdiff(ls(), lsf.str()))");
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        log.debug(String.format("Min is : " + rMin, new Object[0]));
        this.min.emit((Object)rMin);
        this.numList.clear();
    }
}

