/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.r;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.contrib.r.REngineConnectable;
import com.datatorrent.lib.script.ScriptOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RScript
extends ScriptOperator {
    private static final long serialVersionUID = 201401161205L;
    @NotNull
    private Map<String, REXP_TYPE> argTypeMap;
    private String returnVariable = "retVal";
    @NotNull
    private String functionName;
    @NotNull
    protected String scriptFilePath;
    REngineConnectable connectable;
    private static Logger log = LoggerFactory.getLogger(RScript.class);
    public final transient DefaultOutputPort<Integer> intOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<Double> doubleOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> strOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<Boolean> boolOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<Integer[]> intArrayOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<Double[]> doubleArrayOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<String[]> strArrayOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<Boolean[]> boolArrayOutput = new DefaultOutputPort();

    public RScript() {
    }

    public RScript(String rScriptFilePath, String rFunction, String returnVariable) {
        this.setScriptFilePath(rScriptFilePath);
        super.setScript(this.readFileAsString());
        this.setFunctionName(rFunction);
        this.setReturnVariable(returnVariable);
    }

    public Map<String, REXP_TYPE> getArgTypeMap() {
        return this.argTypeMap;
    }

    public void setArgTypeMap(Map<String, REXP_TYPE> argTypeMap) {
        this.argTypeMap = argTypeMap;
    }

    public Map<String, Object> getBindings() {
        return null;
    }

    public String getReturnVariable() {
        return this.returnVariable;
    }

    public void setReturnVariable(String returnVariable) {
        this.returnVariable = returnVariable;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    public void setScriptFilePath(String scriptFilePath) {
        this.scriptFilePath = scriptFilePath;
    }

    public void process(Map<String, Object> tuple) {
        this.processTuple(tuple);
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.connectable = new REngineConnectable();
            this.connectable.connect();
            REXP result = this.connectable.getRengine().parseAndEval(this.script);
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public void teardown() {
        try {
            this.connectable.disconnect();
        }
        catch (IOException ioe) {
            log.error("Exception: ", (Throwable)ioe);
            DTThrowable.rethrow((Exception)ioe);
        }
    }

    private String readFileAsString() {
        StringBuffer fileData = new StringBuffer(1000);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.scriptFilePath)));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
        }
        catch (IOException ioe) {
            log.error("Exception: ", (Throwable)ioe);
            DTThrowable.rethrow((Exception)ioe);
        }
        return fileData.toString();
    }

    public void processTuple(Map<String, Object> tuple) {
        block28: {
            try {
                block12: for (Map.Entry<String, Object> entry : tuple.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    switch (this.argTypeMap.get(key)) {
                        case REXP_INT: {
                            int[] iArr = new int[]{(Integer)value};
                            this.connectable.getRengine().assign(key, (REXP)new REXPInteger(iArr));
                            continue block12;
                        }
                        case REXP_DOUBLE: {
                            double[] dArr = new double[]{(Double)value};
                            this.connectable.getRengine().assign(key, (REXP)new REXPDouble(dArr));
                            continue block12;
                        }
                        case REXP_STR: {
                            String[] sArr = new String[]{(String)value};
                            this.connectable.getRengine().assign(key, (REXP)new REXPString(sArr));
                            continue block12;
                        }
                        case REXP_BOOL: {
                            Boolean[] bArr = new Boolean[]{(Boolean)value};
                            this.connectable.getRengine().assign(key, (REXP)new REXPLogical(bArr[0].booleanValue()));
                            continue block12;
                        }
                        case REXP_ARRAY_INT: {
                            this.connectable.getRengine().assign(key, (REXP)new REXPInteger((int[])value));
                            continue block12;
                        }
                        case REXP_ARRAY_DOUBLE: {
                            this.connectable.getRengine().assign(key, (REXP)new REXPDouble((double[])value));
                            continue block12;
                        }
                        case REXP_ARRAY_STR: {
                            this.connectable.getRengine().assign(key, (REXP)new REXPString((String[])value));
                            continue block12;
                        }
                        case REXP_ARRAY_BOOL: {
                            this.connectable.getRengine().assign(key, (REXP)new REXPLogical((boolean[])value));
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported data type ... ");
                }
                REXP result = this.connectable.getRengine().parseAndEval(this.getReturnVariable() + "<-" + this.getFunctionName() + "()");
                REXP retVal = this.connectable.getRengine().parseAndEval(this.getReturnVariable());
                this.connectable.getRengine().parseAndEval("rm(list = setdiff(ls(), lsf.str()))");
                int len = 0;
                if (retVal.isInteger()) {
                    len = retVal.length();
                    if (len > 1) {
                        Integer[] iAList = new Integer[len];
                        for (int i = 0; i < len; ++i) {
                            iAList[i] = retVal.asIntegers()[i];
                        }
                        this.intArrayOutput.emit((Object)iAList);
                    } else {
                        this.intOutput.emit((Object)retVal.asInteger());
                    }
                    break block28;
                }
                if (retVal.isNumeric()) {
                    len = retVal.length();
                    if (len > 1) {
                        Double[] dAList = new Double[len];
                        for (int i = 0; i < len; ++i) {
                            dAList[i] = retVal.asDoubles()[i];
                        }
                        this.doubleArrayOutput.emit((Object)dAList);
                    } else {
                        this.doubleOutput.emit((Object)retVal.asDouble());
                    }
                    break block28;
                }
                if (retVal.isString()) {
                    len = retVal.length();
                    if (len > 1) {
                        this.strArrayOutput.emit((Object)retVal.asStrings());
                    } else {
                        this.strOutput.emit((Object)retVal.asString());
                    }
                    break block28;
                }
                if (retVal.isLogical()) {
                    len = retVal.length();
                    boolean[] bData = new boolean[len];
                    if (len > 1) {
                        Boolean[] bAList = new Boolean[len];
                        for (int i = 0; i < len; ++i) {
                            bAList[i] = ((REXPLogical)retVal).isTRUE()[i];
                        }
                        this.boolArrayOutput.emit((Object)bAList);
                    } else {
                        bData = ((REXPLogical)retVal).isTRUE();
                        this.boolOutput.emit((Object)bData[0]);
                    }
                    break block28;
                }
                throw new IllegalArgumentException("Unsupported data type returned ... ");
            }
            catch (Exception e) {
                log.error("Exception: ", (Throwable)e);
                DTThrowable.rethrow((Exception)e);
            }
        }
    }

    public static enum REXP_TYPE {
        REXP_INT(1),
        REXP_DOUBLE(2),
        REXP_STR(3),
        REXP_BOOL(6),
        REXP_ARRAY_INT(32),
        REXP_ARRAY_DOUBLE(33),
        REXP_ARRAY_STR(34),
        REXP_ARRAY_BOOL(36);

        private int value;

        private REXP_TYPE(int value) {
            this.value = value;
        }
    }
}

