/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.rabbitmq;

import com.datatorrent.api.Context;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.netlet.util.DTThrowable;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.apex.malhar.lib.wal.WindowDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRabbitMQOutputOperator
extends BaseOperator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRabbitMQOutputOperator.class);
    transient ConnectionFactory connFactory = new ConnectionFactory();
    transient QueueingConsumer consumer = null;
    transient Connection connection = null;
    transient Channel channel = null;
    transient String exchange = "testEx";
    transient String queueName = "testQ";
    private WindowDataManager windowDataManager;
    private transient long currentWindowId;
    private transient long largestRecoveryWindowId;
    private transient int operatorContextId;
    protected transient boolean skipProcessingTuple = false;
    private transient Context.OperatorContext context;

    public void setup(Context.OperatorContext context) {
        this.context = context;
        this.operatorContextId = context.getId();
        try {
            this.connFactory.setHost("localhost");
            this.connection = this.connFactory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.exchangeDeclare(this.exchange, "fanout");
            this.windowDataManager.setup((Context)context);
        }
        catch (IOException ex) {
            logger.debug(ex.toString());
            DTThrowable.rethrow((Exception)ex);
        }
    }

    public void beginWindow(long windowId) {
        this.currentWindowId = windowId;
        this.largestRecoveryWindowId = this.windowDataManager.getLargestCompletedWindow();
        this.skipProcessingTuple = windowId <= this.largestRecoveryWindowId;
    }

    public void endWindow() {
        if (this.currentWindowId < this.largestRecoveryWindowId) {
            return;
        }
        try {
            this.windowDataManager.save((Object)"processedWindow", this.currentWindowId);
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
        }
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void teardown() {
        try {
            this.channel.close();
            this.connection.close();
            this.windowDataManager.teardown();
        }
        catch (IOException ex) {
            logger.debug(ex.toString());
        }
    }

    public WindowDataManager getWindowDataManager() {
        return this.windowDataManager;
    }

    public void setWindowDataManager(WindowDataManager windowDataManager) {
        this.windowDataManager = windowDataManager;
    }
}

