/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.redis;

import com.datatorrent.lib.db.TransactionableKeyValueStore;
import com.google.common.collect.Maps;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceStore
implements TransactionableKeyValueStore {
    private String host = "localhost";
    private int port = 6379;
    private int dbIndex = 0;
    protected int keyExpiryTime = -1;
    protected transient RedisClient client;
    protected transient RedisConnection<String, String> connection;
    private transient boolean inTransaction;
    private static final Logger LOG = LoggerFactory.getLogger(LettuceStore.class);

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public int getKeyExpiryTime() {
        return this.keyExpiryTime;
    }

    public void setKeyExpiryTime(int keyExpiryTime) {
        this.keyExpiryTime = keyExpiryTime;
    }

    public void connect() throws IOException {
        this.client = new RedisClient(this.host, this.port);
        this.connection = this.client.connect();
        this.connection.select(this.dbIndex);
    }

    public void disconnect() throws IOException {
        this.client.shutdown();
        this.connection = null;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void beginTransaction() {
        this.connection.multi();
        this.inTransaction = true;
    }

    public void commitTransaction() {
        this.connection.exec();
        this.inTransaction = false;
    }

    public void rollbackTransaction() {
        this.connection.discard();
        this.inTransaction = false;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public Object get(Object key) {
        if (this.isInTransaction()) {
            throw new RuntimeException("Cannot call get when in redis transaction");
        }
        return this.connection.get((Object)key.toString());
    }

    public List<Object> getAll(List<Object> keys) {
        if (this.isInTransaction()) {
            throw new RuntimeException("Cannot call get when in redis transaction");
        }
        return this.connection.mget((Object[])keys.toArray(new String[0]));
    }

    public void put(Object key, Object value) {
        if (value instanceof Map) {
            this.connection.hmset((Object)key.toString(), (Map)value);
        } else {
            this.connection.set((Object)key.toString(), (Object)value.toString());
        }
        if (this.keyExpiryTime != -1) {
            this.connection.expire((Object)key.toString(), (long)this.keyExpiryTime);
        }
    }

    public void putAll(Map<Object, Object> m) {
        HashMap params = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            params.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.connection.mset((Map)params);
    }

    public void remove(Object key) {
        this.connection.del((Object[])new String[]{key.toString()});
    }

    public void hincrByFloat(String key, String field, double doubleValue) {
        this.connection.hincrbyfloat((Object)key, (Object)field, doubleValue);
        if (this.keyExpiryTime != -1) {
            this.connection.expire((Object)key, (long)this.keyExpiryTime);
        }
    }

    public void incrByFloat(String key, double doubleValue) {
        this.connection.incrbyfloat((Object)key, doubleValue);
        if (this.keyExpiryTime != -1) {
            this.connection.expire((Object)key, (long)this.keyExpiryTime);
        }
    }

    public long getCommittedWindowId(String appId, int operatorId) {
        Object value = this.get(this.getCommittedWindowKey(appId, operatorId));
        return value == null ? -1L : Long.valueOf(value.toString());
    }

    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        this.put(this.getCommittedWindowKey(appId, operatorId), windowId);
    }

    protected Object getCommittedWindowKey(String appId, int operatorId) {
        return "_dt_wid:" + appId + ":" + operatorId;
    }

    public void removeCommittedWindowId(String appId, int operatorId) {
        this.remove(this.getCommittedWindowKey(appId, operatorId));
    }
}

