/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.redis;

import com.datatorrent.contrib.redis.AbstractRedisAggregateOutputOperator;
import com.datatorrent.contrib.redis.RedisStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableDouble;
import org.apache.commons.lang.mutable.MutableLong;

class NumberSummation<K, V> {
    private AbstractRedisAggregateOutputOperator<?> operator;
    private Map<Object, Object> dataMap;

    NumberSummation(AbstractRedisAggregateOutputOperator<?> operator, Map<Object, Object> dataMap) {
        this.operator = operator;
        this.dataMap = dataMap;
    }

    protected Number convertToNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof MutableDouble || o instanceof MutableLong) {
            return (Number)o;
        }
        if (o instanceof Double || o instanceof Float) {
            return new MutableDouble((Number)o);
        }
        if (o instanceof Number) {
            return new MutableLong((Number)o);
        }
        return new MutableDouble(o.toString());
    }

    public void storeAggregate() {
        for (Map.Entry<Object, Object> entry : this.dataMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                for (Map.Entry entry1 : ((Map)value).entrySet()) {
                    String field = entry1.getKey().toString();
                    Object hvalue = entry1.getValue();
                    if (hvalue instanceof Number) {
                        ((RedisStore)this.operator.getStore()).hincrByFloat(key.toString(), field, ((Number)hvalue).doubleValue());
                        continue;
                    }
                    ((RedisStore)this.operator.getStore()).hincrByFloat(key.toString(), field, Double.parseDouble(hvalue.toString()));
                }
                continue;
            }
            if (value instanceof Number) {
                ((RedisStore)this.operator.getStore()).incrByFloat(key.toString(), ((Number)value).doubleValue());
                continue;
            }
            ((RedisStore)this.operator.getStore()).incrByFloat(key.toString(), Double.parseDouble(value.toString()));
        }
        this.dataMap.clear();
    }

    public void process(K key, V value) throws RuntimeException {
        if (value instanceof Map) {
            HashMap o = this.dataMap.get(key);
            if (o == null) {
                o = new HashMap();
                this.dataMap.put(key, o);
            }
            if (!(o instanceof Map)) {
                throw new RuntimeException("Values of unexpected type in data map. Expecting Map");
            }
            Map map = o;
            for (Map.Entry entry1 : ((Map)value).entrySet()) {
                Object field = entry1.getKey();
                Number oldVal = (Number)map.get(field);
                if (oldVal == null) {
                    map.put(field, this.convertToNumber(entry1.getValue()));
                    continue;
                }
                if (oldVal instanceof MutableDouble) {
                    ((MutableDouble)oldVal).add(this.convertToNumber(entry1.getValue()));
                    continue;
                }
                if (oldVal instanceof MutableLong) {
                    ((MutableLong)oldVal).add(this.convertToNumber(entry1.getValue()));
                    continue;
                }
                throw new RuntimeException("Values of unexpected type in data map value field type. Expecting MutableLong or MutableDouble");
            }
        } else {
            Number oldVal = this.convertToNumber(this.dataMap.get(key));
            if (oldVal == null) {
                this.dataMap.put(key, this.convertToNumber(value));
            } else if (oldVal instanceof MutableDouble) {
                ((MutableDouble)oldVal).add(this.convertToNumber(value));
            } else if (oldVal instanceof MutableLong) {
                ((MutableLong)oldVal).add(this.convertToNumber(value));
            } else {
                throw new RuntimeException("Values of unexpected type in data map value type. Expecting MutableLong or MutableDouble");
            }
        }
    }
}

