/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.redis;

import com.datatorrent.contrib.redis.AbstractRedisAggregateOutputOperator;
import com.datatorrent.contrib.redis.RedisStore;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.KeyValPair;
import com.datatorrent.lib.util.PojoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RedisPOJOOutputOperator
extends AbstractRedisAggregateOutputOperator<KeyValPair<String, Object>> {
    protected final Map<String, Object> map = new HashMap<String, Object>();
    private ArrayList<FieldInfo> dataColumns;
    private transient ArrayList<Object> getters = new ArrayList();
    private boolean isFirstTuple = true;

    public void storeAggregate() {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Map<String, String> mapObject = this.convertObjectToMap(entry.getValue());
            ((RedisStore)this.store).put(entry.getKey(), mapObject);
        }
    }

    private Map<String, String> convertObjectToMap(Object tuple) {
        HashMap<String, String> mappedObject = new HashMap<String, String>();
        for (int i = 0; i < this.dataColumns.size(); ++i) {
            FieldInfo.SupportType type = this.dataColumns.get(i).getType();
            String columnName = this.dataColumns.get(i).getColumnName();
            if (i >= this.getters.size()) continue;
            PojoUtils.Getter obj = (PojoUtils.Getter)this.getters.get(i);
            Object value = obj.get(tuple);
            mappedObject.put(columnName, value.toString());
        }
        return mappedObject;
    }

    public void processFirstTuple(KeyValPair<String, Object> tuple) {
        Object value = tuple.getValue();
        Class<?> fqcn = value.getClass();
        int size = this.dataColumns.size();
        for (int i = 0; i < size; ++i) {
            PojoUtils.GetterBoolean getter;
            FieldInfo.SupportType type = this.dataColumns.get(i).getType();
            String getterExpression = this.dataColumns.get(i).getPojoFieldExpression();
            switch (type) {
                case STRING: {
                    getter = PojoUtils.createGetter(fqcn, (String)getterExpression, String.class);
                    break;
                }
                case BOOLEAN: {
                    getter = PojoUtils.createGetterBoolean(fqcn, (String)getterExpression);
                    break;
                }
                case SHORT: {
                    getter = PojoUtils.createGetterShort(fqcn, (String)getterExpression);
                    break;
                }
                case INTEGER: {
                    getter = PojoUtils.createGetter(fqcn, (String)getterExpression, (Class)type.getJavaType());
                    break;
                }
                case LONG: {
                    getter = PojoUtils.createGetterLong(fqcn, (String)getterExpression);
                    break;
                }
                case FLOAT: {
                    getter = PojoUtils.createGetterFloat(fqcn, (String)getterExpression);
                    break;
                }
                case DOUBLE: {
                    getter = PojoUtils.createGetterDouble(fqcn, (String)getterExpression);
                    break;
                }
                default: {
                    getter = PojoUtils.createGetter(fqcn, (String)getterExpression, Object.class);
                }
            }
            this.getters.add(getter);
        }
    }

    public void processTuple(KeyValPair<String, Object> tuple) {
        if (this.isFirstTuple) {
            this.processFirstTuple(tuple);
        }
        this.isFirstTuple = false;
        this.map.put((String)tuple.getKey(), tuple.getValue());
    }

    public ArrayList<FieldInfo> getDataColumns() {
        return this.dataColumns;
    }

    public void setDataColumns(ArrayList<FieldInfo> dataColumns) {
        this.dataColumns = dataColumns;
    }
}

