/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.redis;

import com.datatorrent.lib.db.TransactionableKeyValueStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;

public class RedisStore
implements TransactionableKeyValueStore {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStore.class);
    protected transient Jedis jedis;
    private String host = "localhost";
    private int port = 6379;
    private int dbIndex = 0;
    protected int keyExpiryTime = -1;
    private transient Transaction transaction;
    private transient int timeOut = 30000;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public int getKeyExpiryTime() {
        return this.keyExpiryTime;
    }

    public void setKeyExpiryTime(int keyExpiryTime) {
        this.keyExpiryTime = keyExpiryTime;
    }

    public void connect() throws IOException {
        this.jedis = new Jedis(this.host, this.port, this.timeOut);
        this.jedis.connect();
        this.jedis.select(this.dbIndex);
    }

    public void disconnect() throws IOException {
        this.jedis.disconnect();
    }

    public boolean isConnected() {
        return this.jedis != null && this.jedis.isConnected();
    }

    public void beginTransaction() {
        this.transaction = this.jedis.multi();
    }

    public void commitTransaction() {
        this.transaction.exec();
        this.transaction = null;
    }

    public void rollbackTransaction() {
        this.transaction.discard();
        this.transaction = null;
    }

    public boolean isInTransaction() {
        return this.transaction != null;
    }

    public Object get(Object key) {
        if (this.isInTransaction()) {
            throw new RuntimeException("Cannot call get when in redis transaction");
        }
        return this.jedis.get(key.toString());
    }

    public String getType(String key) {
        return this.jedis.type(key);
    }

    public Map<String, String> getMap(Object key) {
        if (this.isInTransaction()) {
            throw new RuntimeException("Cannot call get when in redis transaction");
        }
        return this.jedis.hgetAll(key.toString());
    }

    public List<Object> getAll(List<Object> keys) {
        if (this.isInTransaction()) {
            throw new RuntimeException("Cannot call get when in redis transaction");
        }
        return this.jedis.mget(keys.toArray(new String[0]));
    }

    public void put(Object key, Object value) {
        if (this.isInTransaction()) {
            if (value instanceof Map) {
                this.transaction.hmset(key.toString(), (Map)value);
            } else {
                this.transaction.set(key.toString(), value.toString());
            }
            if (this.keyExpiryTime != -1) {
                this.transaction.expire(key.toString(), this.keyExpiryTime);
            }
        } else {
            if (value instanceof Map) {
                this.jedis.hmset(key.toString(), (Map)value);
            } else {
                this.jedis.set(key.toString(), value.toString());
            }
            if (this.keyExpiryTime != -1) {
                this.jedis.expire(key.toString(), this.keyExpiryTime);
            }
        }
    }

    public void putAll(Map<Object, Object> m) {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            params.add(entry.getKey().toString());
            params.add(entry.getValue().toString());
        }
        if (this.isInTransaction()) {
            this.transaction.mset(params.toArray(new String[0]));
        } else {
            this.jedis.mset(params.toArray(new String[0]));
        }
    }

    public void remove(Object key) {
        if (this.isInTransaction()) {
            this.transaction.del(key.toString());
        } else {
            this.jedis.del(key.toString());
        }
    }

    public ScanResult<String> ScanKeys(Integer offset, ScanParams params) {
        return this.jedis.scan(offset.toString(), params);
    }

    public void hincrByFloat(String key, String field, double doubleValue) {
        if (this.isInTransaction()) {
            this.transaction.hincrByFloat(key, field, doubleValue);
            if (this.keyExpiryTime != -1) {
                this.transaction.expire(key, this.keyExpiryTime);
            }
        } else {
            this.jedis.hincrByFloat(key, field, doubleValue);
            if (this.keyExpiryTime != -1) {
                this.jedis.expire(key, this.keyExpiryTime);
            }
        }
    }

    public void incrByFloat(String key, double doubleValue) {
        if (this.isInTransaction()) {
            this.transaction.incrByFloat(key, doubleValue);
            if (this.keyExpiryTime != -1) {
                this.transaction.expire(key, this.keyExpiryTime);
            }
        } else {
            this.jedis.incrByFloat(key, doubleValue);
            if (this.keyExpiryTime != -1) {
                this.jedis.expire(key, this.keyExpiryTime);
            }
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public long getCommittedWindowId(String appId, int operatorId) {
        Object value = this.get(this.getCommittedWindowKey(appId, operatorId));
        return value == null ? -1L : Long.valueOf(value.toString());
    }

    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        this.put(this.getCommittedWindowKey(appId, operatorId), windowId);
    }

    protected Object getCommittedWindowKey(String appId, int operatorId) {
        return "_dt_wid:" + appId + ":" + operatorId;
    }

    public void removeCommittedWindowId(String appId, int operatorId) {
        this.remove(this.getCommittedWindowKey(appId, operatorId));
    }
}

