/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.romesyndication;

import com.datatorrent.contrib.romesyndication.RomeFeedEntry;
import com.datatorrent.contrib.romesyndication.RomeStreamProvider;
import com.datatorrent.lib.io.SimpleSinglePortInputOperator;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomeSyndicationOperator
extends SimpleSinglePortInputOperator<RomeFeedEntry>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RomeSyndicationOperator.class);
    private String location;
    private RomeStreamProvider streamProvider;
    private int interval;
    private boolean orderedUpdate = false;
    private List<RomeFeedEntry> feedItems = new ArrayList<RomeFeedEntry>();

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setStreamProvider(RomeStreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    public RomeStreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    public void setOrderedUpdate(boolean orderedUpdate) {
        this.orderedUpdate = orderedUpdate;
    }

    public boolean isOrderedUpdate() {
        return this.orderedUpdate;
    }

    private InputStream getFeedInputStream() throws IOException {
        InputStream is;
        if (this.streamProvider != null) {
            is = this.streamProvider.getInputStream();
        } else {
            URL url = new URL(this.location);
            is = url.openStream();
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(this.getFeedInputStream());
                    SyndFeedInput feedInput = new SyndFeedInput();
                    SyndFeed feed = feedInput.build((Reader)isr);
                    List entries = feed.getEntries();
                    ArrayList<RomeFeedEntry> nfeedItems = new ArrayList<RomeFeedEntry>();
                    boolean oldEntries = false;
                    for (int i = 0; i < entries.size(); ++i) {
                        SyndEntry syndEntry = (SyndEntry)entries.get(i);
                        RomeFeedEntry romeFeedEntry = this.getSerializableEntry(syndEntry);
                        if (!oldEntries) {
                            if (!this.feedItems.contains(romeFeedEntry)) {
                                this.outputPort.emit((Object)romeFeedEntry);
                            } else if (this.orderedUpdate) {
                                oldEntries = true;
                            }
                        }
                        nfeedItems.add(romeFeedEntry);
                    }
                    this.feedItems = nfeedItems;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                finally {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (Exception ce) {
                            logger.error(ce.getMessage());
                        }
                    }
                }
                Thread.sleep(this.interval);
            }
        }
        catch (InterruptedException ie) {
            logger.error("Interrupted: " + ie.getMessage());
            return;
        }
    }

    private RomeFeedEntry getSerializableEntry(SyndEntry syndEntry) {
        SyndEntryImpl serSyndEntry = new SyndEntryImpl();
        serSyndEntry.copyFrom((Object)syndEntry);
        RomeFeedEntry romeFeedEntry = new RomeFeedEntry((SyndEntry)serSyndEntry);
        return romeFeedEntry;
    }
}

