/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.ruby;

import com.datatorrent.api.Context;
import com.datatorrent.lib.script.ScriptOperator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;

@InterfaceStability.Evolving
public class RubyOperator
extends ScriptOperator {
    protected Type type = Type.EVAL;
    protected transient Object evalResult;
    private transient ScriptingContainer sc = null;
    private transient JavaEmbedUtils.EvalUnit unit;

    public void setEval(String script) {
        this.type = Type.EVAL;
        this.script = script;
    }

    public void setInvoke(String functionName) {
        this.type = Type.INVOKE;
        this.script = functionName;
    }

    public void setup(Context.OperatorContext context) {
        this.sc = new ScriptingContainer(LocalVariableBehavior.PERSISTENT);
        for (String s : this.setupScripts) {
            EmbedEvalUnit unit = this.sc.parse(s, new int[0]);
            unit.run();
        }
        if (this.type == Type.EVAL) {
            this.unit = this.sc.parse(this.script, new int[0]);
        }
    }

    public void process(Map<String, Object> tuple) {
        try {
            if (this.type == Type.EVAL) {
                for (Map.Entry<String, Object> entry : tuple.entrySet()) {
                    this.sc.put(entry.getKey(), entry.getValue());
                }
                this.evalResult = this.unit.run();
            } else {
                Object[] args = new Object[tuple.size()];
                int index = 0;
                for (Map.Entry<String, Object> entry : tuple.entrySet()) {
                    args[index++] = entry.getValue();
                }
                this.evalResult = this.sc.callMethod(this.evalResult, this.script, args);
            }
            if (this.isPassThru && this.result.isConnected()) {
                this.result.emit(this.evalResult);
            }
            if (this.isPassThru && this.outBindings.isConnected()) {
                this.outBindings.emit(this.getBindings());
            }
            this.sc.clear();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void endWindow() {
        if (!this.isPassThru) {
            if (this.result.isConnected()) {
                this.result.emit(this.evalResult);
            }
            if (this.outBindings.isConnected()) {
                this.outBindings.emit(this.getBindings());
            }
        }
    }

    public Map<String, Object> getBindings() {
        if (this.sc == null) {
            return null;
        }
        if (this.sc.getVarMap() != null) {
            return this.sc.getVarMap().getMap();
        }
        return null;
    }

    public static enum Type {
        EVAL,
        INVOKE;

    }
}

