/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.solr;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.solr.SolrServerConnector;
import com.datatorrent.lib.db.AbstractStoreOutputOperator;
import com.datatorrent.lib.db.Connectable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import javax.validation.constraints.NotNull;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolrOutputOperator<T, S extends Connectable>
extends AbstractStoreOutputOperator<T, S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSolrOutputOperator.class);
    @NotNull
    protected SolrServerConnector solrServerConnector;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private int bufferSize = 0x100000;
    private transient Queue<SolrInputDocument> docBuffer;

    public void processTuple(T tuple) {
        SolrInputDocument solrDocument;
        if (this.docBuffer.size() >= this.bufferSize) {
            this.processTuples();
        }
        if ((solrDocument = this.convertTuple(tuple)) != null) {
            this.docBuffer.add(solrDocument);
        }
    }

    public abstract SolrInputDocument convertTuple(T var1);

    public void setup(Context.OperatorContext context) {
        this.docBuffer = new ArrayBlockingQueue<SolrInputDocument>(this.bufferSize);
        try {
            this.solrServerConnector.connect();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to connect to Solr server", ex);
        }
    }

    public void teardown() {
        this.docBuffer.clear();
        this.solrServerConnector.getSolrServer().shutdown();
    }

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
        this.processTuples();
    }

    private void processTuples() {
        try {
            SolrServer solrServer = this.solrServerConnector.getSolrServer();
            solrServer.add(this.docBuffer);
            UpdateResponse response = solrServer.commit();
            if (response.getStatus() != 0) {
                throw new RuntimeException("Unable to add data to solr server");
            }
            logger.debug("Submitted documents batch of size " + this.docBuffer.size() + " to Solr server.");
            this.docBuffer.clear();
        }
        catch (SolrServerException ex) {
            throw new RuntimeException("Unable to insert documents during process", ex);
        }
        catch (SolrException ex) {
            throw new RuntimeException("Unable to insert documents during process", ex);
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to insert documents during process", iox);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public SolrServerConnector getSolrServerConnector() {
        return this.solrServerConnector;
    }

    public void setSolrServerConnector(SolrServerConnector solrServerConnector) {
        this.solrServerConnector = solrServerConnector;
    }
}

