/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.splunk;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.splunk.SplunkStore;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import com.splunk.Event;
import com.splunk.JobExportArgs;
import com.splunk.MultiResultsReaderXml;
import com.splunk.SearchResults;
import java.io.InputStream;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSplunkInputOperator<T>
extends AbstractStoreInputOperator<T, SplunkStore> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSplunkInputOperator.class);
    @NotNull
    protected String earliestTime;
    protected String latestTime;
    protected transient JobExportArgs exportArgs;
    protected transient InputStream exportSearch;
    protected transient MultiResultsReaderXml multiResultsReader;

    public void setEarliestTime(@NotNull String earliestTime) {
        this.earliestTime = earliestTime;
    }

    public void setLatestTime(@NotNull String latestTime) {
        this.latestTime = latestTime;
    }

    public abstract T getTuple(String var1);

    public abstract String queryToRetrieveData();

    public void setup(Context.OperatorContext t1) {
        super.setup(t1);
        this.exportArgs = new JobExportArgs();
        this.exportArgs.setEarliestTime(this.earliestTime);
        this.exportArgs.setLatestTime(this.latestTime);
        this.exportArgs.setSearchMode(JobExportArgs.SearchMode.NORMAL);
    }

    public void emitTuples() {
        String query = this.queryToRetrieveData();
        logger.debug(String.format("select statement: %s", query));
        try {
            this.exportSearch = ((SplunkStore)this.store).getService().export(this.queryToRetrieveData(), this.exportArgs);
            this.multiResultsReader = new MultiResultsReaderXml(this.exportSearch);
            for (SearchResults searchResults : this.multiResultsReader) {
                for (Event event : searchResults) {
                    for (String key : event.keySet()) {
                        if (!key.contains("raw")) continue;
                        T tuple = this.getTuple(event.get(key));
                        this.outputPort.emit(tuple);
                    }
                }
            }
            this.multiResultsReader.close();
        }
        catch (Exception e) {
            ((SplunkStore)this.store).disconnect();
            throw new RuntimeException(String.format("Error while running query: %s", query), e);
        }
    }
}

