/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.splunk;

import com.datatorrent.lib.db.Connectable;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkStore
implements Connectable {
    protected static final Logger logger = LoggerFactory.getLogger(SplunkStore.class);
    private String userName;
    private String password;
    @NotNull
    protected String host;
    @NotNull
    protected int port;
    protected transient Service service = null;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(@NotNull String host) {
        this.host = host;
    }

    public void setPort(@NotNull int port) {
        this.port = port;
    }

    public Service getService() {
        return this.service;
    }

    public void connect() {
        try {
            ServiceArgs loginArgs = new ServiceArgs();
            loginArgs.setUsername(this.userName);
            loginArgs.setPassword(this.password);
            loginArgs.setHost(this.host);
            loginArgs.setPort(this.port);
            this.service = Service.connect((Map)loginArgs);
        }
        catch (Exception e) {
            throw new RuntimeException("closing connection", e);
        }
    }

    public void disconnect() {
        try {
            this.service.logout();
        }
        catch (Exception e) {
            throw new RuntimeException("closing connection", e);
        }
    }

    public boolean isConnected() {
        return this.service.getToken() != null;
    }
}

