/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.zmq;

import com.datatorrent.api.Context;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.common.util.BaseOperator;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public abstract class AbstractBaseZeroMQInputOperator
extends BaseOperator
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseZeroMQInputOperator.class);
    protected transient ZMQ.Context context;
    protected transient ZMQ.Socket subscriber;
    protected transient ZMQ.Socket syncclient;
    private String url;
    private String syncUrl;
    private String filter = "";
    private static final int DEFAULT_BLAST_SIZE = 1000;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private int tuple_blast = 1000;
    private int bufferSize = 0x100000;
    private volatile boolean running = false;
    transient ArrayBlockingQueue<byte[]> holdingBuffer = new ArrayBlockingQueue(this.bufferSize);

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSyncUrl(String url) {
        this.syncUrl = url;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setTupleBlast(int i) {
        this.tuple_blast = i;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setup(Context.OperatorContext ctx) {
        this.context = ZMQ.context((int)1);
        this.subscriber = this.context.socket(2);
        this.subscriber.connect(this.url);
        this.subscriber.subscribe(this.filter.getBytes());
        this.syncclient = this.context.socket(3);
        this.syncclient.connect(this.syncUrl);
        this.syncclient.send("".getBytes(), 0);
    }

    public void teardown() {
        this.subscriber.close();
        this.syncclient.close();
        this.context.term();
    }

    public void activate(Context.OperatorContext ctx) {
        new Thread(){

            @Override
            public void run() {
                AbstractBaseZeroMQInputOperator.this.running = true;
                while (AbstractBaseZeroMQInputOperator.this.running) {
                    try {
                        byte[] message = AbstractBaseZeroMQInputOperator.this.subscriber.recv(0);
                        if (message == null) continue;
                        AbstractBaseZeroMQInputOperator.this.holdingBuffer.add(message);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
        }.start();
    }

    public void deactivate() {
        this.running = false;
    }

    public abstract void emitTuple(byte[] var1);

    public void emitTuples() {
        byte[] msg;
        int ntuples = this.tuple_blast;
        if (ntuples > this.holdingBuffer.size()) {
            ntuples = this.holdingBuffer.size();
        }
        int i = ntuples;
        while (i-- > 0 && (msg = this.holdingBuffer.poll()) != null) {
            this.emitTuple(msg);
        }
    }
}

