/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.contrib.misc.streamquery;

import com.datatorrent.api.Context;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.apex.malhar.contrib.misc.streamquery.AbstractSqlStreamOperator;

@Deprecated
public class DerbySqlStreamOperator
extends AbstractSqlStreamOperator {
    protected transient ArrayList<PreparedStatement> insertStatements = new ArrayList(5);
    protected List<String> execStmtStringList = new ArrayList<String>();
    protected transient ArrayList<PreparedStatement> execStatements = new ArrayList(5);
    protected transient ArrayList<PreparedStatement> deleteStatements = new ArrayList(5);
    protected transient Connection db;

    public void addExecStatementString(String stmt) {
        this.execStmtStringList.add(stmt);
    }

    public void setup(Context.OperatorContext context) {
        System.setProperty("derby.stream.error.file", "/dev/null");
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String connUrl = "jdbc:derby:memory:MALHAR_TEMP;create=true";
        try {
            this.db = DriverManager.getConnection(connUrl);
            for (int i = 0; i < this.inputSchemas.size(); ++i) {
                AbstractSqlStreamOperator.InputSchema inputSchema = (AbstractSqlStreamOperator.InputSchema)this.inputSchemas.get(i);
                if (inputSchema == null || inputSchema.columnInfoMap.isEmpty()) continue;
                String columnSpec = "";
                String columnNames = "";
                String insertQuestionMarks = "";
                int j = 0;
                for (Map.Entry<String, AbstractSqlStreamOperator.InputSchema.ColumnInfo> entry : inputSchema.columnInfoMap.entrySet()) {
                    if (!columnSpec.isEmpty()) {
                        columnSpec = columnSpec + ",";
                        columnNames = columnNames + ",";
                        insertQuestionMarks = insertQuestionMarks + ",";
                    }
                    columnSpec = columnSpec + entry.getKey();
                    columnSpec = columnSpec + " ";
                    columnSpec = columnSpec + entry.getValue().type;
                    columnNames = columnNames + entry.getKey();
                    insertQuestionMarks = insertQuestionMarks + "?";
                    entry.getValue().bindIndex = ++j;
                }
                String createTempTableStmt = "DECLARE GLOBAL TEMPORARY TABLE SESSION." + inputSchema.name + "(" + columnSpec + ") NOT LOGGED";
                PreparedStatement st = this.db.prepareStatement(createTempTableStmt);
                st.execute();
                st.close();
                String insertStmt = "INSERT INTO SESSION." + inputSchema.name + " (" + columnNames + ") VALUES (" + insertQuestionMarks + ")";
                this.insertStatements.add(i, this.db.prepareStatement(insertStmt));
                this.deleteStatements.add(i, this.db.prepareStatement("DELETE FROM SESSION." + inputSchema.name));
            }
            for (String stmtStr : this.execStmtStringList) {
                this.execStatements.add(this.db.prepareStatement(stmtStr));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void beginWindow(long windowId) {
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processTuple(int tableNum, HashMap<String, Object> tuple) {
        AbstractSqlStreamOperator.InputSchema inputSchema = (AbstractSqlStreamOperator.InputSchema)this.inputSchemas.get(tableNum);
        PreparedStatement insertStatement = this.insertStatements.get(tableNum);
        try {
            for (Map.Entry<String, Object> entry : tuple.entrySet()) {
                AbstractSqlStreamOperator.InputSchema.ColumnInfo t = inputSchema.columnInfoMap.get(entry.getKey());
                if (t == null || t.bindIndex == 0) continue;
                insertStatement.setString(t.bindIndex, entry.getValue().toString());
            }
            insertStatement.executeUpdate();
            insertStatement.clearParameters();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void endWindow() {
        try {
            this.db.commit();
            if (this.bindings != null) {
                for (int i = 0; i < this.bindings.size(); ++i) {
                    for (PreparedStatement stmt : this.execStatements) {
                        stmt.setString(i, this.bindings.get(i).toString());
                    }
                }
            }
            for (PreparedStatement stmt : this.execStatements) {
                this.executePreparedStatement(stmt);
            }
            for (PreparedStatement st : this.deleteStatements) {
                st.executeUpdate();
                st.clearParameters();
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        this.bindings = null;
    }

    private void executePreparedStatement(PreparedStatement statement) throws SQLException {
        ResultSet res = statement.executeQuery();
        ResultSetMetaData resmeta = res.getMetaData();
        int columnCount = resmeta.getColumnCount();
        while (res.next()) {
            HashMap<String, Object> resultRow = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                resultRow.put(resmeta.getColumnName(i), res.getObject(i));
            }
            this.result.emit(resultRow);
        }
        statement.clearParameters();
    }

    public void teardown() {
        try {
            this.db.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

