/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.contrib.parser;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.KeyValPair;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.contrib.parser.LogSchemaDetails;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class LogParser
extends Parser<byte[], KeyValPair<String, String>> {
    private transient Class<?> clazz;
    @NotNull
    private String logFileFormat;
    private String encoding;
    private LogSchemaDetails logSchemaDetails;
    private transient ObjectMapper objMapper;
    public transient DefaultOutputPort<Object> parsedOutput = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            LogParser.this.clazz = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    @AutoMetric
    long parsedOutputCount;
    private static final Logger logger = LoggerFactory.getLogger(LogParser.class);

    public Object convert(byte[] tuple) {
        throw new UnsupportedOperationException("Not supported");
    }

    public KeyValPair<String, String> processErrorTuple(byte[] bytes) {
        return null;
    }

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.parsedOutputCount = 0L;
    }

    public void setup(Context.OperatorContext context) {
        this.objMapper = new ObjectMapper();
        this.encoding = this.encoding != null ? this.encoding : "UTF-8";
        this.setupLog();
    }

    public void processTuple(byte[] inputTuple) {
        if (inputTuple == null) {
            this.emitError(null, "null tuple");
            return;
        }
        String incomingString = "";
        try {
            incomingString = new String(inputTuple, this.encoding);
            if (StringUtils.isBlank((CharSequence)incomingString)) {
                this.emitError(incomingString, "Blank tuple");
                return;
            }
            logger.debug("Input string {} ", (Object)incomingString);
            logger.debug("Parsing with log format {}", (Object)this.geLogFileFormat());
            if (this.logSchemaDetails != null && this.clazz != null && this.parsedOutput.isConnected()) {
                this.parsedOutput.emit(this.objMapper.readValue(this.logSchemaDetails.createJsonFromLog(incomingString).toString().getBytes(), this.clazz));
                ++this.parsedOutputCount;
            }
        }
        catch (IOException | NullPointerException | JSONException e) {
            this.emitError(incomingString, e.getMessage());
            logger.error("Failed to parse log tuple {}, Exception = {} ", (Object)inputTuple, (Object)e);
        }
    }

    public void emitError(String tuple, String errorMsg) {
        if (this.err.isConnected()) {
            this.err.emit((Object)new KeyValPair((Object)tuple, (Object)errorMsg));
        }
        ++this.errorTupleCount;
    }

    public void setupLog() {
        try {
            this.logSchemaDetails = new LogSchemaDetails(this.logFileFormat);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while initializing the custom log format " + e.getMessage());
        }
    }

    public void setLogFileFormat(String logFileFormat) {
        this.logFileFormat = logFileFormat;
    }

    public String geLogFileFormat() {
        return this.logFileFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public LogSchemaDetails getLogSchemaDetails() {
        return this.logSchemaDetails;
    }

    public void setLogSchemaDetails(LogSchemaDetails logSchemaDetails) {
        this.logSchemaDetails = logSchemaDetails;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }
}

