/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.contrib.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSchemaDetails {
    private List<String> fieldNames = new LinkedList<String>();
    private List<Field> fields = new LinkedList<Field>();
    private Pattern compiledPattern = null;
    private String pattern;
    private static final Logger logger = LoggerFactory.getLogger(LogSchemaDetails.class);

    public LogSchemaDetails(String json) {
        try {
            this.initialize(json);
            this.createPattern();
            this.compiledPattern = Pattern.compile(this.pattern);
        }
        catch (IOException | JSONException e) {
            logger.error("{}", e);
            throw new IllegalArgumentException(e);
        }
    }

    private void initialize(String json) throws JSONException, IOException {
        JSONObject jsonObject = new JSONObject(json);
        JSONArray fieldArray = jsonObject.getJSONArray("fields");
        for (int i = 0; i < fieldArray.length(); ++i) {
            JSONObject obj = fieldArray.getJSONObject(i);
            Field field = new Field(obj.getString("field"), obj.getString("regex"));
            this.fields.add(field);
            this.fieldNames.add(field.name);
        }
    }

    public void createPattern() {
        StringBuffer pattern = new StringBuffer();
        for (Field field : this.getFields()) {
            pattern.append(field.getRegex()).append(" ");
        }
        logger.info("Created pattern for parsing the log {}", (Object)pattern.toString().trim());
        this.setPattern(pattern.toString().trim());
    }

    public JSONObject createJsonFromLog(String log) throws JSONException {
        JSONObject logObject = null;
        if (this.compiledPattern != null) {
            Matcher m = this.compiledPattern.matcher(log);
            int count = m.groupCount();
            if (m.find()) {
                int i = 1;
                logObject = new JSONObject();
                for (String field : this.getFieldNames()) {
                    if (i > count) break;
                    logObject.put(field, (Object)m.group(i));
                    ++i;
                }
            }
        }
        return logObject;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public class Field {
        private String name;
        private String regex;

        public Field(String name, String regex) {
            this.name = name;
            this.regex = regex;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public String toString() {
            return "Fields [name=" + this.name + ", regex=" + this.regex + "]";
        }
    }
}

