/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasRelationshipDef
extends AtlasStructDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RelationshipCategory relationshipCategory;
    private String relationshipLabel;
    private PropagateTags propagateTags;
    private AtlasRelationshipEndDef endDef1;
    private AtlasRelationshipEndDef endDef2;

    public AtlasRelationshipDef() {
        this((String)null, (String)null, (String)null, (RelationshipCategory)null, (PropagateTags)null, (AtlasRelationshipEndDef)null, (AtlasRelationshipEndDef)null);
    }

    public AtlasRelationshipDef(String name, String description, String typeVersion, RelationshipCategory relationshipCategory, PropagateTags propagatetags, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2) {
        this(name, description, typeVersion, relationshipCategory, propagatetags, endDef1, endDef2, new ArrayList<AtlasStructDef.AtlasAttributeDef>());
    }

    public AtlasRelationshipDef(String name, String description, String typeVersion, String serviceType, RelationshipCategory relationshipCategory, PropagateTags propagatetags, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2) {
        this(name, description, typeVersion, serviceType, relationshipCategory, propagatetags, endDef1, endDef2, new ArrayList<AtlasStructDef.AtlasAttributeDef>());
    }

    public AtlasRelationshipDef(String name, String description, String typeVersion, RelationshipCategory relationshipCategory, PropagateTags propagatetags, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, null, relationshipCategory, propagatetags, endDef1, endDef2, attributeDefs);
    }

    public AtlasRelationshipDef(String name, String description, String typeVersion, String serviceType, RelationshipCategory relationshipCategory, PropagateTags propagatetags, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        super(TypeCategory.RELATIONSHIP, name, description, typeVersion, attributeDefs, serviceType, null);
        this.setRelationshipCategory(relationshipCategory);
        this.setRelationshipLabel(null);
        this.setPropagateTags(propagatetags);
        this.setEndDef1(endDef1);
        this.setEndDef2(endDef2);
    }

    public AtlasRelationshipDef(AtlasRelationshipDef other) {
        super(other);
        if (other != null) {
            this.setRelationshipCategory(other.getRelationshipCategory());
            this.setRelationshipLabel(other.getRelationshipLabel());
            this.setPropagateTags(other.getPropagateTags());
            this.setEndDef1(other.getEndDef1());
            this.setEndDef2(other.getEndDef2());
        }
    }

    public void setRelationshipCategory(RelationshipCategory relationshipCategory) {
        this.relationshipCategory = relationshipCategory;
    }

    public RelationshipCategory getRelationshipCategory() {
        return this.relationshipCategory;
    }

    public void setRelationshipLabel(String relationshipLabel) {
        this.relationshipLabel = relationshipLabel;
    }

    public String getRelationshipLabel() {
        return this.relationshipLabel;
    }

    public void setPropagateTags(PropagateTags propagateTags) {
        this.propagateTags = propagateTags;
    }

    public PropagateTags getPropagateTags() {
        return this.propagateTags;
    }

    public void setEndDef1(AtlasRelationshipEndDef endDef1) {
        this.endDef1 = endDef1;
    }

    public AtlasRelationshipEndDef getEndDef1() {
        return this.endDef1;
    }

    public void setEndDef2(AtlasRelationshipEndDef endDef2) {
        this.endDef2 = endDef2;
    }

    public AtlasRelationshipEndDef getEndDef2() {
        return this.endDef2;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasRelationshipDef{");
        super.toString(sb);
        sb.append(',');
        sb.append((Object)this.relationshipCategory);
        sb.append(',');
        sb.append(this.relationshipLabel);
        sb.append(',');
        sb.append((Object)this.propagateTags);
        sb.append(',');
        if (this.endDef1 != null) {
            sb.append(this.endDef1.toString());
        } else {
            sb.append(" end1 is null!");
        }
        sb.append(',');
        if (this.endDef2 != null) {
            sb.append(this.endDef2.toString());
        } else {
            sb.append(" end2 is null!");
        }
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasRelationshipDef that = (AtlasRelationshipDef)o;
        if (!Objects.equals((Object)this.relationshipCategory, (Object)that.getRelationshipCategory())) {
            return false;
        }
        if (!Objects.equals(this.relationshipLabel, that.getRelationshipLabel())) {
            return false;
        }
        if (!Objects.equals((Object)this.propagateTags, (Object)that.getPropagateTags())) {
            return false;
        }
        if (!Objects.equals(this.endDef1, that.getEndDef1())) {
            return false;
        }
        return Objects.equals(this.endDef2, that.getEndDef2());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.relationshipCategory, this.relationshipLabel, this.propagateTags, this.endDef1, this.endDef2});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum PropagateTags {
        NONE,
        ONE_TO_TWO,
        TWO_TO_ONE,
        BOTH;

    }

    public static enum RelationshipCategory {
        ASSOCIATION,
        AGGREGATION,
        COMPOSITION;

    }
}

