/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.notification.AtlasNotificationBaseMessage;
import org.apache.atlas.model.notification.MessageSource;
import org.apache.atlas.model.notification.MessageVersion;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasNotificationMessage<T>
extends AtlasNotificationBaseMessage {
    private String msgSourceIP;
    private String msgCreatedBy;
    private long msgCreationTime;
    private boolean spooled;
    private T message;

    public AtlasNotificationMessage() {
    }

    public AtlasNotificationMessage(MessageVersion version, T message) {
        this(version, message, null, null, false);
    }

    public AtlasNotificationMessage(MessageVersion version, T message, String msgSourceIP, String createdBy, boolean spooled) {
        this(version, message, msgSourceIP, createdBy, spooled, null);
    }

    public AtlasNotificationMessage(MessageVersion version, T message, String msgSourceIP, String createdBy, boolean spooled, MessageSource source) {
        super(version, source);
        this.msgSourceIP = msgSourceIP;
        this.msgCreatedBy = createdBy;
        this.msgCreationTime = new Date().getTime();
        this.message = message;
        this.spooled = spooled;
    }

    public AtlasNotificationMessage(MessageVersion version, T message, String msgSourceIP, String createdBy) {
        this(version, message, msgSourceIP, createdBy, false, null);
    }

    public String getMsgSourceIP() {
        return this.msgSourceIP;
    }

    public void setMsgSourceIP(String msgSourceIP) {
        this.msgSourceIP = msgSourceIP;
    }

    public String getMsgCreatedBy() {
        return this.msgCreatedBy;
    }

    public void setMsgCreatedBy(String msgCreatedBy) {
        this.msgCreatedBy = msgCreatedBy;
    }

    public long getMsgCreationTime() {
        return this.msgCreationTime;
    }

    public void setMsgCreationTime(long msgCreationTime) {
        this.msgCreationTime = msgCreationTime;
    }

    public T getMessage() {
        return this.message;
    }

    public void setMessage(T message) {
        this.message = message;
    }

    public void setSpooled(boolean val) {
        this.spooled = val;
    }

    public boolean getSpooled() {
        return this.spooled;
    }
}

