/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasEntityType {
    private static final String TYPE_TABLE = "my_table";
    private static final String TYPE_COLUMN = "my_column";
    private static final String ATTR_TABLE = "table";
    private static final String ATTR_COLUMNS = "columns";
    private static final String ATTR_OWNER = "owner";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LOCATION = "location";
    private final AtlasEntityType entityType;
    private final List<Object> validValues = new ArrayList<Object>();
    private final List<Object> invalidValues = new ArrayList<Object>();

    public TestAtlasEntityType() {
        this.entityType = TestAtlasEntityType.getEntityType(ModelTestUtil.getEntityDefWithSuperTypes());
        AtlasEntity invalidValue1 = this.entityType.createDefaultValue();
        AtlasEntity invalidValue2 = this.entityType.createDefaultValue();
        Map invalidValue3 = this.entityType.createDefaultValue().getAttributes();
        invalidValue1.setAttribute(ModelTestUtil.getDefaultAttributeName("int"), (Object)"xyz");
        invalidValue2.setAttribute(ModelTestUtil.getDefaultAttributeName("date"), (Object)"xyz");
        invalidValue3.put(ModelTestUtil.getDefaultAttributeName("biginteger"), "xyz");
        this.validValues.add(null);
        this.validValues.add(this.entityType.createDefaultValue());
        this.validValues.add(this.entityType.createDefaultValue().getAttributes());
        this.invalidValues.add(invalidValue1);
        this.invalidValues.add(invalidValue2);
        this.invalidValues.add(invalidValue3);
        this.invalidValues.add(new AtlasEntity());
        this.invalidValues.add(new HashMap());
        this.invalidValues.add(1);
        this.invalidValues.add(new HashSet());
        this.invalidValues.add(new ArrayList());
        this.invalidValues.add(new String[0]);
    }

    @Test
    public void testEntityTypeDefaultValue() {
        AtlasEntity defValue = this.entityType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
        Assert.assertEquals((String)defValue.getTypeName(), (String)this.entityType.getTypeName());
    }

    @Test
    public void testEntityTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.entityType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.entityType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testEntityTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.entityType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Object normalizedValue = this.entityType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.entityType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testEntityTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.entityType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.entityType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidConstraints() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        String failureMsg = null;
        entityDefs.add(this.createTableEntityDef());
        entityDefs.add(this.createColumnEntityDef());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            AtlasEntityType typeTable = ttr.getEntityTypeByName(TYPE_TABLE);
            AtlasEntityType typeColumn = ttr.getEntityTypeByName(TYPE_COLUMN);
            Assert.assertTrue((boolean)typeTable.getAttribute(ATTR_COLUMNS).isOwnedRef());
            Assert.assertNull((Object)typeTable.getAttribute(ATTR_COLUMNS).getInverseRefAttributeName());
            Assert.assertFalse((boolean)typeColumn.getAttribute(ATTR_TABLE).isOwnedRef());
            Assert.assertEquals((String)typeColumn.getAttribute(ATTR_TABLE).getInverseRefAttributeName(), (String)ATTR_COLUMNS);
            Assert.assertEquals((Object)typeColumn.getAttribute(ATTR_TABLE).getInverseRefAttribute(), (Object)typeTable.getAttribute(ATTR_COLUMNS));
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg, (String)"failed to create types my_table and my_column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynAttributeFlags() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        String failureMsg = null;
        entityDefs.add(this.createTableEntityDefWithOptions());
        entityDefs.add(this.createColumnEntityDef());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            AtlasEntityType typeTable = ttr.getEntityTypeByName(TYPE_TABLE);
            AtlasEntityType typeColumn = ttr.getEntityTypeByName(TYPE_COLUMN);
            Assert.assertTrue((boolean)typeTable.getAttribute(ATTR_NAME).getIsDynAttributeEvalTrigger());
            Assert.assertFalse((boolean)typeTable.getAttribute(ATTR_NAME).getIsDynAttribute());
            Assert.assertFalse((boolean)typeTable.getAttribute(ATTR_OWNER).getIsDynAttributeEvalTrigger());
            Assert.assertTrue((boolean)typeTable.getAttribute(ATTR_OWNER).getIsDynAttribute());
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg, (String)"failed to create types my_table and my_column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReorderDynAttributes() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        String failureMsg = null;
        entityDefs.add(this.createTableEntityDefForTopSort());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            AtlasEntityType typeTable = ttr.getEntityTypeByName(TYPE_TABLE);
            Assert.assertEquals((String)((AtlasStructType.AtlasAttribute)typeTable.getDynEvalAttributes().get(0)).getName(), (String)ATTR_DESCRIPTION);
            Assert.assertEquals((String)((AtlasStructType.AtlasAttribute)typeTable.getDynEvalAttributes().get(1)).getName(), (String)ATTR_OWNER);
            Assert.assertEquals((String)((AtlasStructType.AtlasAttribute)typeTable.getDynEvalAttributes().get(2)).getName(), (String)ATTR_NAME);
            Assert.assertEquals((String)((AtlasStructType.AtlasAttribute)typeTable.getDynEvalAttributes().get(3)).getName(), (String)ATTR_LOCATION);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg, (String)"failed to create types my_table and my_column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintInvalidOwnedRef_InvalidAttributeType() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        AtlasErrorCode errorCode = null;
        entityDefs.add(this.createTableEntityDefWithOwnedRefOnInvalidType());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            errorCode = excp.getAtlasErrorCode();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertEquals((Object)errorCode, (Object)AtlasErrorCode.CONSTRAINT_OWNED_REF_ATTRIBUTE_INVALID_TYPE, (String)"expected invalid constraint failure - missing refAttribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintInValidInverseRef_MissingParams() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        AtlasErrorCode errorCode = null;
        entityDefs.add(this.createTableEntityDef());
        entityDefs.add(this.createColumnEntityDefWithMissingInverseAttribute());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            errorCode = excp.getAtlasErrorCode();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertEquals((Object)errorCode, (Object)AtlasErrorCode.CONSTRAINT_MISSING_PARAMS, (String)"expected invalid constraint failure - missing refAttribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintInValidInverseRef_InvalidAttributeTypeForInverseAttribute() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        AtlasErrorCode errorCode = null;
        entityDefs.add(this.createTableEntityDef());
        entityDefs.add(this.createColumnEntityDefWithInvaidAttributeTypeForInverseAttribute());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            errorCode = excp.getAtlasErrorCode();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertEquals((Object)errorCode, (Object)AtlasErrorCode.CONSTRAINT_INVERSE_REF_ATTRIBUTE_INVALID_TYPE, (String)"expected invalid constraint failure - missing refAttribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintInValidInverseRef_InvalidAttributeType() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        AtlasErrorCode errorCode = null;
        entityDefs.add(this.createTableEntityDef());
        entityDefs.add(this.createColumnEntityDefWithInvalidInverseAttributeType());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            errorCode = excp.getAtlasErrorCode();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertEquals((Object)errorCode, (Object)AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_INVALID_TYPE, (String)"expected invalid constraint failure - invalid refAttribute type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintInValidInverseRef_NonExistingAttribute() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
        AtlasErrorCode errorCode = null;
        entityDefs.add(this.createTableEntityDef());
        entityDefs.add(this.createColumnEntityDefWithNonExistingInverseAttribute());
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(entityDefs);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            errorCode = excp.getAtlasErrorCode();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertEquals((Object)errorCode, (Object)AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_NON_EXISTING, (String)"expected invalid constraint failure - non-existing refAttribute");
    }

    private static AtlasEntityType getEntityType(AtlasEntityDef entityDef) {
        try {
            return new AtlasEntityType(entityDef, ModelTestUtil.getTypesRegistry());
        }
        catch (AtlasBaseException excp) {
            return null;
        }
    }

    private AtlasEntityDef createTableEntityDef() {
        AtlasEntityDef table = new AtlasEntityDef(TYPE_TABLE);
        AtlasStructDef.AtlasAttributeDef attrName = new AtlasStructDef.AtlasAttributeDef(ATTR_NAME, "string");
        AtlasStructDef.AtlasAttributeDef attrColumns = new AtlasStructDef.AtlasAttributeDef(ATTR_COLUMNS, AtlasBaseTypeDef.getArrayTypeName((String)TYPE_COLUMN));
        attrColumns.addConstraint(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
        table.addAttribute(attrName);
        table.addAttribute(attrColumns);
        return table;
    }

    private AtlasEntityDef createTableEntityDefWithOptions() {
        AtlasEntityDef table = new AtlasEntityDef(TYPE_TABLE);
        AtlasStructDef.AtlasAttributeDef attrName = new AtlasStructDef.AtlasAttributeDef(ATTR_NAME, "string");
        AtlasStructDef.AtlasAttributeDef attrColumns = new AtlasStructDef.AtlasAttributeDef(ATTR_COLUMNS, AtlasBaseTypeDef.getArrayTypeName((String)TYPE_COLUMN));
        AtlasStructDef.AtlasAttributeDef attrOwner = new AtlasStructDef.AtlasAttributeDef(ATTR_OWNER, "string");
        attrColumns.addConstraint(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
        table.addAttribute(attrName);
        table.addAttribute(attrColumns);
        table.addAttribute(attrOwner);
        HashMap<String, String> options = new HashMap<String, String>();
        String key = "dynAttribute:owner";
        String value = "{name}";
        options.put(key, value);
        table.setOptions(options);
        return table;
    }

    private AtlasEntityDef createTableEntityDefForTopSort() {
        AtlasEntityDef table = new AtlasEntityDef(TYPE_TABLE);
        AtlasStructDef.AtlasAttributeDef attrName = new AtlasStructDef.AtlasAttributeDef(ATTR_NAME, "string");
        AtlasStructDef.AtlasAttributeDef attrOwner = new AtlasStructDef.AtlasAttributeDef(ATTR_OWNER, "string");
        AtlasStructDef.AtlasAttributeDef attrDescription = new AtlasStructDef.AtlasAttributeDef(ATTR_DESCRIPTION, "string");
        AtlasStructDef.AtlasAttributeDef attrLocation = new AtlasStructDef.AtlasAttributeDef(ATTR_LOCATION, "string");
        table.addAttribute(attrName);
        table.addAttribute(attrOwner);
        table.addAttribute(attrDescription);
        table.addAttribute(attrLocation);
        HashMap<String, String> options = new HashMap<String, String>();
        String key1 = "dynAttribute:owner";
        String value1 = "{description}";
        String key2 = "dynAttribute:description";
        String value2 = "template";
        String key3 = "dynAttribute:name";
        String value3 = "{description}@{owner}";
        String key4 = "dynAttribute:location";
        String value4 = "{name}@{owner}";
        options.put(key1, value1);
        options.put(key2, value2);
        options.put(key3, value3);
        options.put(key4, value4);
        table.setOptions(options);
        return table;
    }

    private AtlasEntityDef createTableEntityDefWithOwnedRefOnInvalidType() {
        AtlasEntityDef table = new AtlasEntityDef(TYPE_TABLE);
        AtlasStructDef.AtlasAttributeDef attrName = new AtlasStructDef.AtlasAttributeDef(ATTR_NAME, "string");
        attrName.addConstraint(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
        table.addAttribute(attrName);
        return table;
    }

    private AtlasEntityDef createColumnEntityDefWithMissingInverseAttribute() {
        AtlasEntityDef column = new AtlasEntityDef(TYPE_COLUMN);
        AtlasStructDef.AtlasAttributeDef attrTable = new AtlasStructDef.AtlasAttributeDef(ATTR_TABLE, TYPE_TABLE);
        attrTable.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef"));
        column.addAttribute(attrTable);
        return column;
    }

    private AtlasEntityDef createColumnEntityDefWithInvaidAttributeTypeForInverseAttribute() {
        AtlasEntityDef column = new AtlasEntityDef(TYPE_COLUMN);
        AtlasStructDef.AtlasAttributeDef attrTable = new AtlasStructDef.AtlasAttributeDef(ATTR_NAME, "string");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("attribute", ATTR_NAME);
        attrTable.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", params));
        column.addAttribute(attrTable);
        return column;
    }

    private AtlasEntityDef createColumnEntityDefWithNonExistingInverseAttribute() {
        AtlasEntityDef column = new AtlasEntityDef(TYPE_COLUMN);
        AtlasStructDef.AtlasAttributeDef attrTable = new AtlasStructDef.AtlasAttributeDef(ATTR_TABLE, TYPE_TABLE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("attribute", "non-existing:columns");
        attrTable.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", params));
        column.addAttribute(attrTable);
        return column;
    }

    private AtlasEntityDef createColumnEntityDefWithInvalidInverseAttributeType() {
        AtlasEntityDef column = new AtlasEntityDef(TYPE_COLUMN);
        AtlasStructDef.AtlasAttributeDef attrTable = new AtlasStructDef.AtlasAttributeDef(ATTR_TABLE, TYPE_TABLE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("attribute", ATTR_NAME);
        attrTable.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", params));
        column.addAttribute(attrTable);
        return column;
    }

    private AtlasEntityDef createColumnEntityDef() {
        AtlasEntityDef column = new AtlasEntityDef(TYPE_COLUMN);
        AtlasStructDef.AtlasAttributeDef attrTable = new AtlasStructDef.AtlasAttributeDef(ATTR_TABLE, TYPE_TABLE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("attribute", ATTR_COLUMNS);
        attrTable.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", params));
        column.addAttribute(attrTable);
        return column;
    }
}

