/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasMapType {
    private final AtlasMapType intIntMapType = new AtlasMapType((AtlasType)new AtlasBuiltInTypes.AtlasIntType(), (AtlasType)new AtlasBuiltInTypes.AtlasIntType());
    private final Object[] validValues;
    private final Object[] invalidValues;

    public TestAtlasMapType() {
        HashMap<String, Integer> strIntMap = new HashMap<String, Integer>();
        HashMap<String, Double> strDoubleMap = new HashMap<String, Double>();
        HashMap<String, String> strStringMap = new HashMap<String, String>();
        HashMap<Integer, Integer> intIntMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> objObjMap = new HashMap<Integer, Integer>();
        HashMap<String, String> invObjObjMap1 = new HashMap<String, String>();
        HashMap<String, String> invObjObjMap2 = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            strIntMap.put(Integer.toString(i), i);
            strDoubleMap.put(Integer.toString(i), Double.valueOf(i));
            strStringMap.put(Integer.toString(i), Integer.toString(i));
            intIntMap.put(i, i);
            objObjMap.put(i, i);
        }
        invObjObjMap1.put("xyz", "123");
        invObjObjMap2.put("123", "xyz");
        this.validValues = new Object[]{null, new HashMap(), new HashMap(), strIntMap, strDoubleMap, strStringMap, intIntMap, objObjMap};
        this.invalidValues = new Object[]{invObjObjMap1, invObjObjMap2};
    }

    @Test
    public void testMapTypeDefaultValue() {
        Map defValue = this.intIntMapType.createDefaultValue();
        Assert.assertEquals((int)defValue.size(), (int)1);
    }

    @Test
    public void testMapTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.intIntMapType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.intIntMapType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testMapTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.intIntMapType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Map normalizedValue = this.intIntMapType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.intIntMapType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testMapTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.intIntMapType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.intIntMapType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }
}

