/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.Collections;
import org.apache.atlas.utils.AtlasStringUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AtlasStringUtilTest {
    @Test
    public void testGetOption() {
        Assert.assertNull((Object)AtlasStringUtil.getOption(null, (String)"opt"));
        Assert.assertNull((Object)AtlasStringUtil.getOption(Collections.emptyMap(), null));
        Assert.assertNull((Object)AtlasStringUtil.getOption(Collections.singletonMap("opt", null), null));
        Assert.assertNull((Object)AtlasStringUtil.getOption(Collections.emptyMap(), (String)"opt"));
        Assert.assertNull((Object)AtlasStringUtil.getOption(Collections.singletonMap("opt", "val"), (String)"opt1"));
        Assert.assertEquals((String)AtlasStringUtil.getOption(Collections.singletonMap("opt", "val"), (String)"opt"), (String)"val");
        Assert.assertNotEquals((Object)AtlasStringUtil.getOption(Collections.singletonMap("opt", "val"), (String)"opt"), (Object)"val1");
    }

    @Test
    public void testGetBooleanOption() {
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(null, (String)"opt"));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), null));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", null), (String)"opt"));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), (String)"opt"));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt1"));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt"));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "false"), (String)"opt"));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "true"), (String)"opt"));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "TRUE"), (String)"opt"));
    }

    @Test
    public void testGetBooleanOptionWithDefault() {
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(null, (String)"opt", (boolean)true));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(null, (String)"opt", (boolean)false));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), null, (boolean)true));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), null, (boolean)false));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", null), (String)"opt", (boolean)false));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", null), (String)"opt", (boolean)true));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), (String)"opt", (boolean)true));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.emptyMap(), (String)"opt", (boolean)false));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt1", (boolean)true));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt1", (boolean)false));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt", (boolean)true));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "val"), (String)"opt", (boolean)false));
        Assert.assertFalse((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "false"), (String)"opt", (boolean)true));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "true"), (String)"opt", (boolean)true));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "TRUE"), (String)"opt", (boolean)true));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "true"), (String)"opt", (boolean)false));
        Assert.assertTrue((boolean)AtlasStringUtil.getBooleanOption(Collections.singletonMap("opt", "TRUE"), (String)"opt", (boolean)false));
    }

    @Test
    public void testOptionEquals() {
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(null, (String)"opt", null));
        Assert.assertFalse((boolean)AtlasStringUtil.optionEquals(null, (String)"opt", (String)"val"));
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(Collections.emptyMap(), null, null));
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(Collections.singletonMap("opt", null), (String)"opt", null));
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(Collections.emptyMap(), (String)"opt", null));
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(Collections.singletonMap("opt", "val"), (String)"opt1", null));
        Assert.assertTrue((boolean)AtlasStringUtil.optionEquals(Collections.singletonMap("opt", "val"), (String)"opt", (String)"val"));
        Assert.assertFalse((boolean)AtlasStringUtil.optionEquals(Collections.singletonMap("opt", "val"), (String)"opt", (String)"val1"));
    }
}

