/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasFloatType {
    private final AtlasBuiltInTypes.AtlasFloatType floatType = new AtlasBuiltInTypes.AtlasFloatType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1"};
    private final Object[] validValuesLimitCheck = new Object[]{(byte)-128, (byte)127, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Double.MIN_VALUE};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1L), "-1"};
    private final Object[] negativeValuesLimitCheck = new Object[]{Float.valueOf(-1.4E-45f), Float.valueOf(-3.4028235E38f), -4.9E-324};
    private final Object[] invalidValues = new Object[]{"", "12ab", "abcd", "-12ab", Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), Double.MAX_VALUE, -1.7976931348623157E308};

    @Test
    public void testFloatTypeDefaultValue() {
        Float defValue = this.floatType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)Float.valueOf(0.0f));
    }

    @Test
    public void testFloatTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.floatType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            Assert.assertTrue((boolean)this.floatType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.floatType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            Assert.assertTrue((boolean)this.floatType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.floatType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testFloatTypeGetNormalizedValue() {
        float f;
        Float normalizedValue;
        Assert.assertNull((Object)this.floatType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            normalizedValue = this.floatType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(1.0f), (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            if (value == null) continue;
            normalizedValue = this.floatType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof Float) {
                f = ((Float)value).floatValue();
                Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(f), (String)("value=" + value));
                continue;
            }
            if (value instanceof Double) {
                f = ((Double)value).floatValue();
                Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(f), (String)("value=" + value));
                continue;
            }
            Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(value.toString()), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            normalizedValue = this.floatType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(-1.0f), (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            normalizedValue = this.floatType.getNormalizedValue(value);
            if (value instanceof Float) {
                f = ((Float)value).floatValue();
                Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(f), (String)("value=" + value));
                continue;
            }
            if (!(value instanceof Double)) continue;
            f = ((Double)value).floatValue();
            Assert.assertEquals((Object)normalizedValue, (Object)Float.valueOf(f), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.floatType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testFloatTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.floatType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            Assert.assertTrue((boolean)this.floatType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.floatType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            Assert.assertTrue((boolean)this.floatType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.floatType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

