/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.atlas.model.Clearable;
import org.apache.atlas.utils.FixedBufferList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FixedBufferListTest {
    private String STR_PREFIX = "str:%s";

    @Test
    public void instantiateListWithParameterizedClass() {
        FixedBufferList list = new FixedBufferList(Spying.class);
        Assert.assertNotNull((Object)list);
    }

    @Test
    public void createdBasedOnInitialSize() {
        Spying.resetCounters();
        int incrementByFactor = 2;
        SpyingFixedBufferList fixedBufferList = new SpyingFixedBufferList(incrementByFactor);
        this.addElements(fixedBufferList, 0, 3);
        List list = fixedBufferList.toList();
        this.assertSpyingList(list, 3);
        Assert.assertEquals((int)Spying.callsToCtor.get(), (int)(incrementByFactor * 2));
    }

    @Test(dependsOnMethods={"createdBasedOnInitialSize"})
    public void bufferIncreasesIfNeeded() {
        Spying.resetCounters();
        int incrementSizeBy = 5;
        SpyingFixedBufferList fixedBufferList = new SpyingFixedBufferList(incrementSizeBy);
        this.addElements(fixedBufferList, 0, incrementSizeBy);
        List spyings = fixedBufferList.toList();
        Assert.assertEquals((int)spyings.size(), (int)incrementSizeBy);
        Assert.assertEquals((int)Spying.callsToCtor.get(), (int)incrementSizeBy);
        fixedBufferList.reset();
        this.addElements(fixedBufferList, 0, incrementSizeBy * 2);
        spyings = fixedBufferList.toList();
        Assert.assertEquals((int)Spying.callsToCtor.get(), (int)(incrementSizeBy * 2));
        this.assertSpyingList(spyings, incrementSizeBy * 2);
        Assert.assertEquals((int)Spying.callsToClear.get(), (int)incrementSizeBy);
    }

    @Test
    public void retrieveEmptyList() {
        int size = 5;
        SpyingFixedBufferList fixedBufferList = new SpyingFixedBufferList(size);
        List list = fixedBufferList.toList();
        Assert.assertEquals((int)list.size(), (int)0);
        this.addElements(fixedBufferList, 0, 3);
        list = fixedBufferList.toList();
        Assert.assertEquals((int)list.size(), (int)3);
    }

    private void assertSpyingList(List<Spying> list, int expectedSize) {
        Assert.assertEquals((int)list.size(), (int)expectedSize);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Assert.assertNotNull((Object)list.get(i1));
            this.assertSpying(list.get(i1), i1);
        }
    }

    private void assertSpying(Spying spying, int i) {
        Assert.assertEquals((long)spying.aLong, (long)i);
        Assert.assertEquals((int)spying.anInt, (int)i);
        Assert.assertEquals((String)spying.aString, (String)String.format(this.STR_PREFIX, i));
    }

    private Spying createSpyingClass(Spying spying, int i) {
        spying.aLong = i;
        spying.anInt = i;
        spying.aString = String.format(this.STR_PREFIX, i);
        return spying;
    }

    private void addElements(SpyingFixedBufferList fixedBufferList, int startIndex, int numElements) {
        for (int i = startIndex; i < startIndex + numElements; ++i) {
            Spying spyForUpdate = (Spying)fixedBufferList.next();
            this.createSpyingClass(spyForUpdate, i);
        }
    }

    private static class SpyingFixedBufferList
    extends FixedBufferList<Spying> {
        public SpyingFixedBufferList(int incrementCapacityFactor) {
            super(Spying.class, incrementCapacityFactor);
        }
    }

    public static class Spying
    implements Clearable {
        public static AtomicInteger callsToCtor = new AtomicInteger();
        public static AtomicInteger callsToClear = new AtomicInteger();
        private int anInt;
        private String aString;
        private long aLong;

        public Spying() {
            callsToCtor.incrementAndGet();
        }

        public void clear() {
            callsToClear.incrementAndGet();
            this.anInt = 0;
            this.aString = "";
            this.aLong = 0L;
        }

        public static void resetCounters() {
            callsToCtor.set(0);
            callsToClear.set(0);
        }
    }
}

