/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.MapUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasExportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_FETCH_TYPE = "fetchType";
    public static final String OPTION_ATTR_MATCH_TYPE = "matchType";
    public static final String OPTION_SKIP_LINEAGE = "skipLineage";
    public static final String OPTION_KEY_REPLICATED_TO = "replicatedTo";
    public static final String FETCH_TYPE_FULL = "full";
    public static final String FETCH_TYPE_CONNECTED = "connected";
    public static final String FETCH_TYPE_INCREMENTAL = "incremental";
    public static final String FETCH_TYPE_INCREMENTAL_CHANGE_MARKER = "changeMarker";
    public static final String MATCH_TYPE_STARTS_WITH = "startsWith";
    public static final String MATCH_TYPE_ENDS_WITH = "endsWith";
    public static final String MATCH_TYPE_CONTAINS = "contains";
    public static final String MATCH_TYPE_MATCHES = "matches";
    public static final String MATCH_TYPE_FOR_TYPE = "forType";
    private List<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
    private Map<String, Object> options = new HashMap<String, Object>();

    public List<AtlasObjectId> getItemsToExport() {
        return this.itemsToExport;
    }

    public void setItemsToExport(List<AtlasObjectId> itemsToExport) {
        this.itemsToExport = itemsToExport;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public String getFetchTypeOptionValue() {
        if (MapUtils.isEmpty(this.getOptions()) || !this.getOptions().containsKey(OPTION_FETCH_TYPE)) {
            return FETCH_TYPE_FULL;
        }
        Object o = this.getOptions().get(OPTION_FETCH_TYPE);
        if (o instanceof String) {
            return (String)o;
        }
        return FETCH_TYPE_FULL;
    }

    public boolean getSkipLineageOptionValue() {
        if (MapUtils.isEmpty(this.getOptions()) || !this.getOptions().containsKey(OPTION_SKIP_LINEAGE)) {
            return false;
        }
        Object o = this.getOptions().get(OPTION_SKIP_LINEAGE);
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public String getMatchTypeOptionValue() {
        String matchType = null;
        if (MapUtils.isNotEmpty(this.getOptions()) && this.getOptions().get(OPTION_ATTR_MATCH_TYPE) != null) {
            matchType = this.getOptions().get(OPTION_ATTR_MATCH_TYPE).toString();
        }
        return matchType;
    }

    public long getChangeTokenFromOptions() {
        if (MapUtils.isEmpty(this.getOptions()) || !this.getFetchTypeOptionValue().equalsIgnoreCase(FETCH_TYPE_INCREMENTAL) || !this.getOptions().containsKey(FETCH_TYPE_INCREMENTAL_CHANGE_MARKER)) {
            return 0L;
        }
        return Long.parseLong(this.getOptions().get(FETCH_TYPE_INCREMENTAL_CHANGE_MARKER).toString());
    }

    @JsonIgnore
    public boolean isReplicationOptionSet() {
        return MapUtils.isNotEmpty(this.options) && this.options.containsKey(OPTION_KEY_REPLICATED_TO);
    }

    @JsonIgnore
    public String getOptionKeyReplicatedTo() {
        String replicateToServerName;
        String string = replicateToServerName = this.isReplicationOptionSet() ? (String)this.options.get(OPTION_KEY_REPLICATED_TO) : "";
        if (replicateToServerName == null) {
            return "";
        }
        return replicateToServerName;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasExportRequest{");
        sb.append("itemsToExport={");
        AtlasBaseTypeDef.dumpObjects(this.itemsToExport, sb);
        sb.append("}");
        sb.append("options={");
        AtlasBaseTypeDef.dumpObjects(this.options, sb);
        sb.append("}");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

