/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;

public class IdlFile {
    private final Schema mainSchema;
    private final Protocol protocol;
    private final String namespace;
    private final Map<String, Schema> namedSchemas;
    private final List<String> warnings;

    IdlFile(Protocol protocol, List<String> warnings) {
        this(protocol.getNamespace(), protocol.getTypes(), null, protocol, warnings);
    }

    IdlFile(String namespace, Schema mainSchema, Iterable<Schema> schemas, List<String> warnings) {
        this(namespace, schemas, mainSchema, null, warnings);
    }

    private IdlFile(String namespace, Iterable<Schema> schemas, Schema mainSchema, Protocol protocol, List<String> warnings) {
        this.namespace = namespace;
        this.namedSchemas = new LinkedHashMap<String, Schema>();
        for (Schema namedSchema : schemas) {
            this.namedSchemas.put(namedSchema.getFullName(), namedSchema);
        }
        this.mainSchema = mainSchema;
        this.protocol = protocol;
        this.warnings = Collections.unmodifiableList(new ArrayList<String>(warnings));
    }

    public Schema getMainSchema() {
        return this.mainSchema;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getWarnings(String importFile) {
        return this.warnings.stream().map(warning -> importFile + ' ' + Character.toLowerCase(warning.charAt(0)) + warning.substring(1)).collect(Collectors.toList());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Schema> getNamedSchemas() {
        return Collections.unmodifiableMap(this.namedSchemas);
    }

    public Schema getNamedSchema(String name) {
        Schema result = this.namedSchemas.get(name);
        if (result != null) {
            return result;
        }
        if (this.namespace != null && !name.contains(".")) {
            result = this.namedSchemas.get(this.namespace + '.' + name);
        }
        return result;
    }

    String outputString() {
        if (this.protocol != null) {
            return this.protocol.toString();
        }
        if (this.mainSchema != null) {
            return this.mainSchema.toString();
        }
        if (this.namedSchemas.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        for (Schema schema : this.namedSchemas.values()) {
            buffer.append(',').append(schema);
        }
        buffer.append(']').setCharAt(0, '[');
        return buffer.toString();
    }
}

