/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DataFileInteropTest {
    private static final File DATAFILE_DIR = new File(System.getProperty("test.dir", "/tmp"));

    @BeforeAll
    public static void printDir() {
        System.out.println("Reading data files from directory: " + DATAFILE_DIR.getAbsolutePath());
    }

    @Test
    void generatedGeneric() throws IOException {
        System.out.println("Reading with generic:");
        DatumReaderProvider provider = GenericDatumReader::new;
        this.readFiles(provider);
    }

    @Test
    void generatedSpecific() throws IOException {
        System.out.println("Reading with specific:");
        DatumReaderProvider provider = SpecificDatumReader::new;
        this.readFiles(provider);
    }

    private <T> void readFiles(DatumReaderProvider<T> provider) throws IOException {
        for (File f : Objects.requireNonNull(DATAFILE_DIR.listFiles())) {
            System.out.println("Reading: " + f.getName());
            try (DataFileReader reader = (DataFileReader)DataFileReader.openReader((File)f, provider.get());){
                byte[] user_metadata = reader.getMeta("user_metadata");
                if (user_metadata != null) {
                    Assertions.assertArrayEquals((byte[])"someByteArray".getBytes(StandardCharsets.UTF_8), (byte[])user_metadata);
                }
                int i = 0;
                for (Object datum : reader) {
                    ++i;
                    Assertions.assertNotNull(datum);
                }
                Assertions.assertNotEquals((int)0, (int)i);
            }
        }
    }

    static interface DatumReaderProvider<T> {
        public DatumReader<T> get();
    }
}

