/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Node
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2091286787698121521L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Node\",\"namespace\":\"org.apache.avro\",\"fields\":[{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"children\",\"type\":{\"type\":\"array\",\"items\":\"Node\"}}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Node> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Node> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String label;
    private List<Node> children;
    private static final DatumWriter<Node> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Node> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Node> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Node> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Node> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Node fromByteBuffer(ByteBuffer b) throws IOException {
        return (Node)((Object)DECODER.decode(b));
    }

    public Node() {
    }

    public Node(String label, List<Node> children) {
        this.label = label;
        this.children = children;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.label;
            }
            case 1: {
                return this.children;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.label = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.children = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public Optional<String> getOptionalLabel() {
        return Optional.ofNullable(this.label);
    }

    public void setLabel(String value2) {
        this.label = value2;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Optional<List<Node>> getOptionalChildren() {
        return Optional.ofNullable(this.children);
    }

    public void setChildren(List<Node> value2) {
        this.children = value2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Node other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.label);
        long size0 = this.children.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (Node e0 : this.children) {
            ++actualSize0;
            out.startItem();
            e0.customEncode(out);
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga0;
            this.label = in.readString();
            long size0 = in.readArrayStart();
            GenericData.Array a0 = this.children;
            if (a0 == null) {
                this.children = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("children").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    Node e0;
                    Node node = e0 = ga0 != null ? (Node)((Object)ga0.peek()) : null;
                    if (e0 == null) {
                        e0 = new Node();
                    }
                    e0.customDecode(in);
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
        } else {
            block6: for (int i = 0; i < 2; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.label = in.readString();
                        continue block6;
                    }
                    case 1: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.children;
                        if (a0 == null) {
                            this.children = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("children").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                Node e0;
                                Node node = e0 = ga0 != null ? (Node)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new Node();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Node>
    implements RecordBuilder<Node> {
        private String label;
        private List<Node> children;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.label);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.children)) {
                this.children = (List)this.data().deepCopy(this.fields()[1].schema(), other.children);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
        }

        private Builder(Node other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.label);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.children)) {
                this.children = (List)this.data().deepCopy(this.fields()[1].schema(), (Object)other.children);
                this.fieldSetFlags()[1] = true;
            }
        }

        public String getLabel() {
            return this.label;
        }

        public Optional<String> getOptionalLabel() {
            return Optional.ofNullable(this.label);
        }

        public Builder setLabel(String value2) {
            this.validate(this.fields()[0], value2);
            this.label = value2;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasLabel() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearLabel() {
            this.label = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Optional<List<Node>> getOptionalChildren() {
            return Optional.ofNullable(this.children);
        }

        public Builder setChildren(List<Node> value2) {
            this.validate(this.fields()[1], value2);
            this.children = value2;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasChildren() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearChildren() {
            this.children = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Node build() {
            try {
                Node record = new Node();
                record.label = this.fieldSetFlags()[0] ? this.label : (String)this.defaultValue(this.fields()[0]);
                record.children = this.fieldSetFlags()[1] ? this.children : (List)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

