/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.junit.jupiter.api.Assertions;

public final class RPCMetaTestPlugin
extends RPCPlugin {
    protected final String key;

    public RPCMetaTestPlugin(String keyname) {
        this.key = keyname;
    }

    public void clientStartConnect(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes(StandardCharsets.UTF_8));
        context.requestHandshakeMeta().put(this.key, buf);
    }

    public void serverConnecting(RPCContext context) {
        Assertions.assertNotNull((Object)context.requestHandshakeMeta());
        Assertions.assertNotNull((Object)context.responseHandshakeMeta());
        Assertions.assertNull((Object)context.getRequestPayload());
        Assertions.assertNull((Object)context.getResponsePayload());
        if (!context.requestHandshakeMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.requestHandshakeMeta().get(this.key);
        Assertions.assertNotNull((Object)buf);
        Assertions.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)partialstr);
        Assertions.assertEquals((Object)"ap", (Object)partialstr, (String)"partial string mismatch");
        buf = ByteBuffer.wrap((partialstr + "ac").getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseHandshakeMeta().put(this.key, buf);
    }

    public void clientFinishConnect(RPCContext context) {
        Map handshakeMeta = context.responseHandshakeMeta();
        Assertions.assertNull((Object)context.getRequestPayload());
        Assertions.assertNull((Object)context.getResponsePayload());
        Assertions.assertNotNull((Object)handshakeMeta);
        if (!handshakeMeta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)handshakeMeta.get(this.key);
        Assertions.assertNotNull((Object)buf);
        Assertions.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)partialstr);
        Assertions.assertEquals((Object)"apac", (Object)partialstr, (String)"partial string mismatch");
        buf = ByteBuffer.wrap((partialstr + "he").getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        handshakeMeta.put(this.key, buf);
        this.checkRPCMetaMap(handshakeMeta);
    }

    public void clientSendRequest(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes(StandardCharsets.UTF_8));
        context.requestCallMeta().put(this.key, buf);
        Assertions.assertNotNull((Object)context.getMessage());
        Assertions.assertNotNull((Object)context.getRequestPayload());
        Assertions.assertNull((Object)context.getResponsePayload());
    }

    public void serverReceiveRequest(RPCContext context) {
        Map meta = context.requestCallMeta();
        Assertions.assertNotNull((Object)meta);
        Assertions.assertNotNull((Object)context.getMessage());
        Assertions.assertNull((Object)context.getResponsePayload());
        if (!meta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)meta.get(this.key);
        Assertions.assertNotNull((Object)buf);
        Assertions.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)partialstr);
        Assertions.assertEquals((Object)"ap", (Object)partialstr, (String)"partial string mismatch");
        buf = ByteBuffer.wrap((partialstr + "a").getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        meta.put(this.key, buf);
    }

    public void serverSendResponse(RPCContext context) {
        Assertions.assertNotNull((Object)context.requestCallMeta());
        Assertions.assertNotNull((Object)context.responseCallMeta());
        Assertions.assertNotNull((Object)context.getResponsePayload());
        if (!context.requestCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.requestCallMeta().get(this.key);
        Assertions.assertNotNull((Object)buf);
        Assertions.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)partialstr);
        Assertions.assertEquals((Object)"apa", (Object)partialstr, (String)"partial string mismatch");
        buf = ByteBuffer.wrap((partialstr + "c").getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
    }

    public void clientReceiveResponse(RPCContext context) {
        Assertions.assertNotNull((Object)context.responseCallMeta());
        Assertions.assertNotNull((Object)context.getRequestPayload());
        if (!context.responseCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.responseCallMeta().get(this.key);
        Assertions.assertNotNull((Object)buf);
        Assertions.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)partialstr);
        Assertions.assertEquals((Object)"apac", (Object)partialstr, (String)"partial string mismatch");
        buf = ByteBuffer.wrap((partialstr + "he").getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
        this.checkRPCMetaMap(context.responseCallMeta());
    }

    protected void checkRPCMetaMap(Map<String, ByteBuffer> rpcMeta) {
        Assertions.assertNotNull(rpcMeta);
        Assertions.assertTrue((boolean)rpcMeta.containsKey(this.key), (String)"key not present in map");
        ByteBuffer keybuf = rpcMeta.get(this.key);
        Assertions.assertNotNull((Object)keybuf);
        Assertions.assertTrue((keybuf.remaining() > 0 ? 1 : 0) != 0, (String)"key BB had nothing remaining");
        String str = new String(keybuf.array(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"apache", (Object)str);
    }
}

