/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Foo;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDataFileSpecific {
    @TempDir
    public File DIR;

    @Test
    void specificDatumReaderDefaultCtor() throws IOException {
        int i;
        File file = new File(this.DIR.getPath(), "testSpecificDatumReaderDefaultCtor");
        Schema s1 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Foo\",\"namespace\":\"org.apache.avro\",\"fields\":[{\"name\":\"label\",\"type\":\"string\"},{\"name\":\"id\",\"type\":\"int\"}]}");
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(s1)).create(s1, file);){
            for (i = 0; i < 10; ++i) {
                GenericData.Record r = new GenericData.Record(s1);
                r.put("label", (Object)("" + i));
                r.put("id", (Object)i);
                writer.append((Object)r);
            }
        }
        var4_4 = null;
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new SpecificDatumReader());){
            i = 0;
            for (Foo f : reader) {
                Assertions.assertEquals((Object)("" + i++), (Object)f.getLabel());
            }
            Assertions.assertEquals((int)10, (int)i);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

