/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.errors.TestError;
import org.apache.avro.test.namespace.TestNamespace;
import org.apache.avro.test.namespace.TestRecord;
import org.apache.avro.test.util.MD5;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNamespaceSpecific {
    protected static SocketServer server;
    protected static Transceiver client;
    protected static TestNamespace proxy;

    @BeforeEach
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer((Responder)new SpecificResponder(TestNamespace.class, (Object)new TestImpl()), (SocketAddress)new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));
        proxy = (TestNamespace)SpecificRequestor.getClient(TestNamespace.class, (Transceiver)client);
    }

    @Test
    void echo() throws IOException {
        TestRecord record = new TestRecord();
        record.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        TestRecord echoed = proxy.echo(record);
        Assertions.assertEquals((Object)((Object)record), (Object)((Object)echoed));
        Assertions.assertEquals((int)record.hashCode(), (int)echoed.hashCode());
    }

    @Test
    void error() throws IOException {
        TestError error = null;
        try {
            proxy.error();
        }
        catch (TestError e) {
            error = e;
        }
        Assertions.assertNotNull((Object)((Object)error));
        Assertions.assertEquals((Object)"an error", (Object)error.getMessage$());
    }

    @AfterAll
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
    }

    public static class TestImpl
    implements TestNamespace {
        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public void error() throws TestError {
            throw TestError.newBuilder().setMessage$("an error").build();
        }
    }
}

