/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtocolParsing {
    public static Protocol getSimpleProtocol() throws IOException {
        File file = new File("../../../share/test/schemas/simple.avpr");
        return Protocol.parse((File)file);
    }

    @Test
    void parsing() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Assertions.assertEquals((Object)protocol.getDoc(), (Object)"Protocol used for testing.");
        Assertions.assertEquals((int)6, (int)protocol.getMessages().size());
        Assertions.assertEquals((Object)"Pretend you're in a cave!", (Object)((Protocol.Message)protocol.getMessages().get("echo")).getDoc());
    }

    private static Protocol.Message parseMessage(String message) throws Exception {
        return (Protocol.Message)Protocol.parse((String)("{\"protocol\": \"org.foo.Bar\",\"types\": [],\"messages\": {" + message + "}}")).getMessages().values().iterator().next();
    }

    @Test
    void oneWay() throws Exception {
        Protocol.Message m = TestProtocolParsing.parseMessage("\"ack\": {\"request\": [],\"response\": \"null\",\"one-way\": true}");
        Assertions.assertTrue((boolean)m.isOneWay());
        m = TestProtocolParsing.parseMessage("\"ack\": {\"request\": [],\"one-way\": true}");
        Assertions.assertTrue((boolean)m.isOneWay());
    }

    @Test
    void oneWayResponse() throws Exception {
        Assertions.assertThrows(SchemaParseException.class, () -> TestProtocolParsing.parseMessage("\"ack\": {\"request\": [\"string\"],\"response\": \"string\",\"one-way\": true}"));
    }

    @Test
    void oneWayError() throws Exception {
        Assertions.assertThrows(SchemaParseException.class, () -> TestProtocolParsing.parseMessage("\"ack\": {\"request\": [\"string\"],\"errors\": [],\"one-way\": true}"));
    }

    @Test
    void messageFieldAliases() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Protocol.Message msg = (Protocol.Message)protocol.getMessages().get("hello");
        Assertions.assertNotNull((Object)msg);
        Schema.Field field = msg.getRequest().getField("greeting");
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)field.aliases().contains("salute"));
    }

    @Test
    void messageCustomProperties() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Protocol.Message msg = (Protocol.Message)protocol.getMessages().get("hello");
        Assertions.assertNotNull((Object)msg);
        Schema.Field field = msg.getRequest().getField("greeting");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)"customValue", (Object)field.getProp("customProp"));
    }
}

