/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SimpleException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.reflect.ReflectRequestor;
import org.apache.avro.ipc.reflect.ReflectResponder;
import org.apache.avro.reflect.ReflectData;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestProtocolReflect {
    private static boolean throwUndeclaredError;
    protected static Server server;
    protected static Transceiver client;
    protected static Simple proxy;

    @BeforeEach
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer((Responder)new ReflectResponder(Simple.class, (Object)new TestImpl()), (SocketAddress)new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));
        proxy = (Simple)ReflectRequestor.getClient(Simple.class, (Transceiver)client);
    }

    @Test
    void classLoader() throws Exception {
        ClassLoader loader = new ClassLoader(){};
        ReflectResponder responder = new ReflectResponder(Simple.class, (Object)new TestImpl(), new ReflectData(loader));
        Assertions.assertEquals((Object)responder.getReflectData().getClassLoader(), (Object)loader);
        ReflectRequestor requestor = new ReflectRequestor(Simple.class, client, new ReflectData(loader));
        Assertions.assertEquals((Object)requestor.getReflectData().getClassLoader(), (Object)loader);
    }

    @Test
    void hello() throws IOException {
        String response = proxy.hello("bob");
        Assertions.assertEquals((Object)"goodbye", (Object)response);
    }

    @Test
    void echo() throws IOException {
        TestRecord record = new TestRecord();
        record.name = "foo";
        TestRecord echoed = proxy.echo(record);
        Assertions.assertEquals((Object)record, (Object)echoed);
    }

    @Test
    void add() throws IOException {
        int result = proxy.add(1, 2);
        Assertions.assertEquals((int)3, (int)result);
    }

    @Test
    void echoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        byte[] data = new byte[length];
        random.nextBytes(data);
        byte[] echoed = proxy.echoBytes(data);
        Assertions.assertArrayEquals((byte[])data, (byte[])echoed);
    }

    @Test
    void error() throws IOException {
        SimpleException error = null;
        try {
            proxy.error();
        }
        catch (SimpleException e) {
            error = e;
        }
        Assertions.assertNotNull((Object)error);
        Assertions.assertEquals((Object)"foo", (Object)error.getMessage());
    }

    @Test
    void undeclaredError() throws Exception {
        throwUndeclaredError = true;
        AvroRuntimeException error = null;
        try {
            proxy.error();
        }
        catch (AvroRuntimeException e) {
            error = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assertions.assertNotNull((Object)((Object)error));
        Assertions.assertTrue((boolean)error.toString().contains("foo"));
    }

    @AfterAll
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
    }

    public static class TestImpl
    implements Simple {
        @Override
        public String hello(String greeting) {
            return "goodbye";
        }

        @Override
        public int add(int arg1, int arg2) {
            return arg1 + arg2;
        }

        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public byte[] echoBytes(byte[] data) {
            return data;
        }

        @Override
        public void error() throws SimpleException {
            if (throwUndeclaredError) {
                throw new RuntimeException("foo");
            }
            throw new SimpleException("foo");
        }
    }

    public static interface Simple {
        public String hello(String var1);

        public TestRecord echo(TestRecord var1);

        public int add(int var1, int var2);

        public byte[] echoBytes(byte[] var1);

        public void error() throws SimpleException;
    }

    public static class TestRecord {
        private String name;

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object that) {
            return this.name.equals(((TestRecord)that).name);
        }
    }
}

