/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Random;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestError;
import org.apache.avro.test.TestRecord;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestProtocolSpecific {
    protected static final int REPEATING = -1;
    public static int ackCount;
    private static boolean throwUndeclaredError;
    protected static Server server;
    protected static Transceiver client;
    protected static Simple proxy;
    protected static SpecificResponder responder;
    protected static HandshakeMonitor monitor;

    @BeforeEach
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        responder = new SpecificResponder(Simple.class, (Object)new TestImpl());
        server = this.createServer((Responder)responder);
        server.start();
        client = this.createTransceiver();
        SpecificRequestor req = new SpecificRequestor(Simple.class, client);
        this.addRpcPlugins((Requestor)req);
        proxy = (Simple)SpecificRequestor.getClient(Simple.class, (SpecificRequestor)req);
        monitor = new HandshakeMonitor();
        responder.addRPCPlugin((RPCPlugin)monitor);
    }

    public void addRpcPlugins(Requestor requestor) {
    }

    public Server createServer(Responder testResponder) throws Exception {
        server = new SocketServer(testResponder, (SocketAddress)new InetSocketAddress(0));
        return server;
    }

    public Transceiver createTransceiver() throws Exception {
        return new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));
    }

    @Test
    void classLoader() throws Exception {
        ClassLoader loader = new ClassLoader(){};
        SpecificResponder responder = new SpecificResponder(Simple.class, (Object)new TestImpl(), new SpecificData(loader));
        Assertions.assertEquals((Object)responder.getSpecificData().getClassLoader(), (Object)loader);
        SpecificRequestor requestor = new SpecificRequestor(Simple.class, client, new SpecificData(loader));
        Assertions.assertEquals((Object)requestor.getSpecificData().getClassLoader(), (Object)loader);
    }

    @Test
    void getRemote() throws IOException {
        Assertions.assertEquals((Object)Simple.PROTOCOL, (Object)SpecificRequestor.getRemote((Object)proxy));
    }

    @Test
    void hello() throws IOException {
        String response = proxy.hello("bob");
        Assertions.assertEquals((Object)"goodbye", (Object)response);
    }

    @Test
    void testHashCode() throws IOException {
        TestError error = new TestError();
        error.hashCode();
    }

    @Test
    void echo() throws IOException {
        TestRecord record = new TestRecord();
        record.setName("foo");
        record.setKind(Kind.BAR);
        record.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        TestRecord echoed = proxy.echo(record);
        Assertions.assertEquals((Object)((Object)record), (Object)((Object)echoed));
        Assertions.assertEquals((int)record.hashCode(), (int)echoed.hashCode());
    }

    @Test
    void add() throws IOException {
        int result = proxy.add(1, 2);
        Assertions.assertEquals((int)3, (int)result);
    }

    @Test
    void echoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        ByteBuffer data = ByteBuffer.allocate(length);
        random.nextBytes(data.array());
        data.flip();
        ByteBuffer echoed = proxy.echoBytes(data);
        Assertions.assertEquals((Object)data, (Object)echoed);
    }

    @Test
    void emptyEchoBytes() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(0);
        ByteBuffer echoed = proxy.echoBytes(data);
        data.flip();
        Assertions.assertEquals((Object)data, (Object)echoed);
    }

    @Test
    void error() throws IOException {
        TestError error = null;
        try {
            proxy.error();
        }
        catch (TestError e) {
            error = e;
        }
        Assertions.assertNotNull((Object)((Object)error));
        Assertions.assertEquals((Object)"an error", (Object)error.getMessage$());
    }

    @Test
    void undeclaredError() throws Exception {
        throwUndeclaredError = true;
        RuntimeException error = null;
        try {
            proxy.error();
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assertions.assertNotNull((Object)error);
        Assertions.assertTrue((boolean)error.toString().contains("foo"));
    }

    @Test
    void oneWay() throws IOException {
        ackCount = 0;
        proxy.ack();
        proxy.hello("foo");
        proxy.ack();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)ackCount);
    }

    @Test
    void repeatedAccess() throws Exception {
        for (int x = 0; x < 1000; ++x) {
            proxy.hello("hi!");
        }
    }

    @Test
    void connectionRefusedOneWay() throws IOException {
        Assertions.assertThrows(Exception.class, () -> {
            HttpTransceiver client = new HttpTransceiver(new URL("http://localhost:4444"));
            SpecificRequestor req = new SpecificRequestor(Simple.class, (Transceiver)client);
            this.addRpcPlugins((Requestor)req);
            Simple proxy = (Simple)SpecificRequestor.getClient(Simple.class, (SpecificRequestor)req);
            proxy.ack();
        });
    }

    @Test
    void paramVariation() throws Exception {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("extra", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null));
        fields.add(new Schema.Field("greeting", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        Protocol.Message message = protocol.createMessage("hello", null, new LinkedHashMap(), Schema.createRecord(fields), Schema.create((Schema.Type)Schema.Type.STRING), Schema.createUnion(new ArrayList()));
        protocol.getMessages().put("hello", message);
        try (Transceiver t = this.createTransceiver();){
            GenericRequestor r = new GenericRequestor(protocol, t);
            this.addRpcPlugins((Requestor)r);
            GenericData.Record params = new GenericData.Record(message.getRequest());
            params.put("extra", (Object)Boolean.TRUE);
            params.put("greeting", (Object)"bob");
            String response = r.request("hello", (Object)params).toString();
            Assertions.assertEquals((Object)"goodbye", (Object)response);
        }
    }

    @AfterAll
    public static void testHandshakeCount() throws IOException {
        monitor.assertHandshake();
    }

    @AfterAll
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
        server = null;
    }

    protected int getExpectedHandshakeCount() {
        return 3;
    }

    public static class InteropTest {
        private static File SERVER_PORTS_DIR;

        @Test
        void client() throws Exception {
            for (File f : Objects.requireNonNull(SERVER_PORTS_DIR.listFiles())) {
                try (LineNumberReader reader = new LineNumberReader(new FileReader(f));){
                    int port = Integer.parseInt(reader.readLine());
                    System.out.println("Validating java client to " + f.getName() + " - " + port);
                    SocketTransceiver client = new SocketTransceiver((SocketAddress)new InetSocketAddress("localhost", port));
                    proxy = (Simple)SpecificRequestor.getClient(Simple.class, (Transceiver)client);
                    TestProtocolSpecific proto = new TestProtocolSpecific();
                    proto.hello();
                    proto.echo();
                    proto.echoBytes();
                    proto.error();
                    System.out.println("Done! Validation java client to " + f.getName() + " - " + port);
                }
            }
        }

        public static void main(String[] args) throws Exception {
            SocketServer server = new SocketServer((Responder)new SpecificResponder(Simple.class, (Object)new TestImpl()), (SocketAddress)new InetSocketAddress(0));
            server.start();
            File portFile = new File(SERVER_PORTS_DIR, "java-port");
            try (FileWriter w = new FileWriter(portFile);){
                w.write(Integer.toString(server.getPort()));
            }
        }

        static {
            try {
                SERVER_PORTS_DIR = Files.createTempDirectory(TestProtocolSpecific.class.getSimpleName(), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class HandshakeMonitor
    extends RPCPlugin {
        private int handshakes;
        private HashSet<String> seenProtocols = new HashSet();

        public void serverConnecting(RPCContext context) {
            ++this.handshakes;
            int expected = TestProtocolSpecific.this.getExpectedHandshakeCount();
            if (expected > 0 && this.handshakes > expected) {
                throw new IllegalStateException("Expected number of Protocol negotiation handshakes exceeded expected " + expected + " was " + this.handshakes);
            }
            String clientProtocol = context.getHandshakeRequest().getClientProtocol();
            if (clientProtocol != null) {
                Assertions.assertFalse((boolean)this.seenProtocols.contains(clientProtocol));
                this.seenProtocols.add(clientProtocol);
            }
        }

        public void assertHandshake() {
            int expected = TestProtocolSpecific.this.getExpectedHandshakeCount();
            if (expected != -1) {
                Assertions.assertEquals((int)expected, (int)this.handshakes, (String)"Expected number of handshakes did not take place.");
            }
        }
    }

    public static class TestImpl
    implements Simple {
        @Override
        public String hello(String greeting) {
            return "goodbye";
        }

        @Override
        public int add(int arg1, int arg2) {
            return arg1 + arg2;
        }

        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public ByteBuffer echoBytes(ByteBuffer data) {
            return data;
        }

        @Override
        public void error() throws TestError {
            if (throwUndeclaredError) {
                throw new RuntimeException("foo");
            }
            throw TestError.newBuilder().setMessage$("an error").build();
        }

        @Override
        public void ack() {
            ++ackCount;
        }
    }
}

