/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.TestAnnotation;
import org.apache.avro.TestProtocolParsing;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;

public class TestSpecificCompiler {
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;
    static final String PROTOCOL = "{ \"protocol\": \"default\",\n  \"types\":\n    [\n      {\n       \"name\": \"finally\",\n       \"type\": \"error\",\n       \"fields\": [{\"name\": \"catch\", \"type\": \"boolean\"}]\n      }\n    ],\n  \"messages\": { \"goto\":\n    { \"request\": [{\"name\": \"break\", \"type\": \"string\"}],\n      \"response\": \"string\",\n      \"errors\": [\"finally\"]\n    }   }\n}\n";
    private static String SCHEMA = "{ \"name\": \"volatile\", \"type\": \"record\",   \"fields\": [ {\"name\": \"package\", \"type\": \"string\" },                {\"name\": \"data\", \"type\": \"int\" },                {\"name\": \"value\", \"type\": \"int\" },                {\"name\": \"defaultValue\", \"type\": \"int\" },                {\"name\": \"other\", \"type\": \"int\" },                {\"name\": \"short\", \"type\": \"volatile\" } ] }";
    private static String SCHEMA1 = "{ \"name\": \"volatile\", \"type\": \"record\",   \"fields\": [{\"name\": \"ownerAddress\", \"type\": [\"null\",{ \"type\": \"string\",\"java-class\": \"java.net.URI\"}], \"default\": null},                {\"name\": \"ownerURL\", \"type\": [\"null\",{ \"type\": \"string\",\"java-class\": \"java.net.URL\"}], \"default\": null}]}";

    @Test
    void esc() {
        Assertions.assertEquals((Object)"\\\"", (Object)SpecificCompiler.javaEscape((String)"\""));
    }

    @Test
    void makePath() {
        SpecificCompiler compiler = new SpecificCompiler();
        Assertions.assertEquals((Object)"foo/bar/Baz.java".replace("/", File.separator), (Object)compiler.makePath("Baz", "foo.bar"));
        Assertions.assertEquals((Object)"baz.java", (Object)compiler.makePath("baz", ""));
    }

    @Test
    void primitiveSchemaGeneratesNothing() {
        Assertions.assertEquals((int)0, (int)new SpecificCompiler(new Schema.Parser().parse("\"double\"")).compile().size());
    }

    @Test
    void simpleEnumSchema(TestInfo testInfo) throws IOException {
        Collection outputs = new SpecificCompiler(new Schema.Parser().parse("{\"type\":\"enum\", \"name\":\"Test\",\"symbols\": [\"A\", \"B\"]}")).compile();
        Assertions.assertEquals((int)1, (int)outputs.size());
        SpecificCompiler.OutputFile o = (SpecificCompiler.OutputFile)outputs.iterator().next();
        Assertions.assertEquals((Object)o.path, (Object)"Test.java");
        Assertions.assertTrue((boolean)o.contents.contains("public enum Test"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), outputs);
    }

    @Test
    void mangleIfReserved() {
        Assertions.assertEquals((Object)"foo", (Object)SpecificCompiler.mangle((String)"foo"));
        Assertions.assertEquals((Object)"goto$", (Object)SpecificCompiler.mangle((String)"goto"));
    }

    @Test
    void manglingForProtocols(TestInfo testInfo) throws IOException {
        Collection outputs = new SpecificCompiler(Protocol.parse((String)PROTOCOL)).compile();
        Iterator i = outputs.iterator();
        String errType = ((SpecificCompiler.OutputFile)i.next()).contents;
        String protocol = ((SpecificCompiler.OutputFile)i.next()).contents;
        Assertions.assertTrue((boolean)errType.contains("public class finally$ extends org.apache.avro.specific.SpecificExceptionBase"));
        Assertions.assertTrue((boolean)errType.contains("private boolean catch$;"));
        Assertions.assertTrue((boolean)protocol.contains("java.lang.CharSequence goto$(java.lang.CharSequence break$)"));
        Assertions.assertTrue((boolean)protocol.contains("public interface default$"));
        Assertions.assertTrue((boolean)protocol.contains(" finally$"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), outputs);
    }

    @Test
    void manglingForRecords(TestInfo testInfo) throws IOException {
        Collection outputs = new SpecificCompiler(new Schema.Parser().parse(SCHEMA)).compile();
        Assertions.assertEquals((int)1, (int)outputs.size());
        String contents = ((SpecificCompiler.OutputFile)outputs.iterator().next()).contents;
        Assertions.assertTrue((boolean)contents.contains("private java.lang.CharSequence package$;"));
        Assertions.assertTrue((boolean)contents.contains("class volatile$ extends"));
        Assertions.assertTrue((boolean)contents.contains("volatile$ short$;"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), outputs);
    }

    @Test
    void manglingForEnums(TestInfo testInfo) throws IOException {
        String enumSchema = "{ \"name\": \"instanceof\", \"type\": \"enum\",  \"symbols\": [\"new\", \"super\", \"switch\"] }";
        Collection outputs = new SpecificCompiler(new Schema.Parser().parse(enumSchema)).compile();
        Assertions.assertEquals((int)1, (int)outputs.size());
        String contents = ((SpecificCompiler.OutputFile)outputs.iterator().next()).contents;
        Assertions.assertTrue((boolean)contents.contains("new$"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), outputs);
    }

    @Test
    void schemaSplit(TestInfo testInfo) throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(new Schema.Parser().parse(SCHEMA));
        compiler.maxStringChars = 10;
        Collection files = compiler.compile();
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), files);
    }

    @Test
    void protocolSplit(TestInfo testInfo) throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(Protocol.parse((String)PROTOCOL));
        compiler.maxStringChars = 10;
        Collection files = compiler.compile();
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.INPUT_DIR, ((Method)testInfo.getTestMethod().get()).getName()), files);
    }

    @Test
    void schemaWithDocs() {
        Collection outputs = new SpecificCompiler(new Schema.Parser().parse("{\n  \"type\": \"record\",\n  \"name\": \"outer_record\",\n  \"doc\": \"This is not a world record.\",\n  \"fields\": [\n    { \"type\": { \"type\": \"fixed\", \"doc\": \"Very Inner Fixed\",                   \"name\": \"very_inner_fixed\", \"size\": 1 },\n      \"doc\": \"Inner Fixed\", \"name\": \"inner_fixed\" },\n    { \"type\": \"string\",\n      \"name\": \"inner_string\",\n      \"doc\": \"Inner String\" },\n    { \"type\": { \"type\": \"enum\", \"doc\": \"Very Inner Enum\", \n                  \"name\": \"very_inner_enum\", \n                  \"symbols\": [ \"A\", \"B\", \"C\" ] },\n      \"doc\": \"Inner Enum\", \"name\": \"inner_enum\" },\n    { \"type\": [\"string\", \"int\"], \"doc\": \"Inner Union\", \n      \"name\": \"inner_union\" }\n  ]\n}\n")).compile();
        Assertions.assertEquals((int)3, (int)outputs.size());
        int count = 0;
        for (SpecificCompiler.OutputFile o : outputs) {
            if (o.path.endsWith("outer_record.java")) {
                ++count;
                Assertions.assertTrue((boolean)o.contents.contains("/** This is not a world record. */"));
                Assertions.assertTrue((boolean)o.contents.contains("/** Inner Fixed */"));
                Assertions.assertTrue((boolean)o.contents.contains("/** Inner Enum */"));
                Assertions.assertTrue((boolean)o.contents.contains("/** Inner String */"));
            }
            if (o.path.endsWith("very_inner_fixed.java")) {
                ++count;
                Assertions.assertTrue((boolean)o.contents.contains("/** Very Inner Fixed */"));
                Assertions.assertTrue((boolean)o.contents.contains("@org.apache.avro.specific.FixedSize(1)"));
            }
            if (!o.path.endsWith("very_inner_enum.java")) continue;
            ++count;
            Assertions.assertTrue((boolean)o.contents.contains("/** Very Inner Enum */"));
        }
        Assertions.assertEquals((int)3, (int)count);
    }

    @Test
    void protocolWithDocs() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Collection out = new SpecificCompiler(protocol).compile();
        Assertions.assertEquals((int)6, (int)out.size());
        int count = 0;
        for (SpecificCompiler.OutputFile o : out) {
            if (!o.path.endsWith("Simple.java")) continue;
            ++count;
            Assertions.assertTrue((boolean)o.contents.contains("/** Protocol used for testing. */"));
            Assertions.assertTrue((boolean)o.contents.contains("* Send a greeting"));
        }
        Assertions.assertEquals((int)1, (int)count, (String)"Missed generated protocol!");
    }

    @Test
    void needCompile() throws IOException, InterruptedException {
        String schema = "{ \"name\": \"Foo\", \"type\": \"record\",   \"fields\": [ {\"name\": \"package\", \"type\": \"string\" },                {\"name\": \"short\", \"type\": \"Foo\" } ] }";
        File inputFile = new File(this.INPUT_DIR.getPath(), "input.avsc");
        try (FileWriter fw = new FileWriter(inputFile);){
            fw.write(schema);
        }
        File outputDir = this.OUTPUT_DIR;
        File outputFile = new File(outputDir, "Foo.java");
        outputFile.delete();
        Assertions.assertFalse((boolean)outputFile.exists());
        outputDir.delete();
        Assertions.assertFalse((boolean)outputDir.exists());
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assertions.assertTrue((boolean)outputDir.exists());
        Assertions.assertTrue((boolean)outputFile.exists());
        long lastModified = outputFile.lastModified();
        Thread.sleep(1000L);
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assertions.assertEquals((long)lastModified, (long)outputFile.lastModified());
        try (FileWriter fw = new FileWriter(inputFile);){
            fw.write(schema);
        }
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assertions.assertTrue((lastModified != outputFile.lastModified() ? 1 : 0) != 0);
    }

    private Schema createRecord(String name, boolean isError, Schema.Field ... fields) {
        Schema record = Schema.createRecord((String)name, null, null, (boolean)isError);
        record.setFields(Arrays.asList(fields));
        return record;
    }

    @Test
    void generateGetMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getHeight", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assertions.assertEquals((Object)"getHeightAndWidth", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assertions.assertEquals((Object)"getMessage", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getMessage$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assertions.assertEquals((Object)"getCause", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getCause$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assertions.assertEquals((Object)"getClass$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getClass$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assertions.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"getHeight", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"getHeight$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"getHeight$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getMessage$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getMessage$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getMessage$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getSchema$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"getSchema$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    void generateSetMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setHeight", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assertions.assertEquals((Object)"setHeightAndWidth", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assertions.assertEquals((Object)"setMessage", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setMessage$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assertions.assertEquals((Object)"setCause", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setCause$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assertions.assertEquals((Object)"setClass$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setClass$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assertions.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"setHeight", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"setHeight$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"setHeight$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setMessage$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setMessage$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setMessage$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setSchema$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"setSchema$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    void generateHasMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasHeight", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assertions.assertEquals((Object)"hasHeightAndWidth", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assertions.assertEquals((Object)"hasMessage", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasMessage$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assertions.assertEquals((Object)"hasCause", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasCause$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assertions.assertEquals((Object)"hasClass$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasClass$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assertions.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"hasHeight", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"hasHeight$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"hasHeight$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasMessage$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasMessage$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasMessage$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasSchema$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"hasSchema$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    void generateClearMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearHeight", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assertions.assertEquals((Object)"clearHeightAndWidth", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assertions.assertEquals((Object)"clearMessage", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearMessage$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assertions.assertEquals((Object)"clearCause", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearCause$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assertions.assertEquals((Object)"clearClass$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearClass$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assertions.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"clearHeight", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"clearHeight$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assertions.assertEquals((Object)"clearHeight$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearMessage$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearMessage$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearMessage$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearSchema$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assertions.assertEquals((Object)"clearSchema$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    void annotations() throws Exception {
        Assertions.assertNotNull((Object)Simple.class.getAnnotation(TestAnnotation.class));
        Assertions.assertNotNull((Object)TestRecord.class.getAnnotation(TestAnnotation.class));
        Assertions.assertNotNull((Object)MD5.class.getAnnotation(TestAnnotation.class));
        Assertions.assertNotNull((Object)Kind.class.getAnnotation(TestAnnotation.class));
        Assertions.assertNotNull((Object)TestRecord.class.getDeclaredField("name").getAnnotation(TestAnnotation.class));
        Assertions.assertNotNull((Object)Simple.class.getMethod("ack", new Class[0]).getAnnotation(TestAnnotation.class));
    }

    @Test
    void aliases() throws IOException {
        Schema s = new Schema.Parser().parse("{\"name\":\"X\",\"type\":\"record\",\"aliases\":[\"Y\"],\"fields\":[{\"name\":\"f\",\"type\":\"int\",\"aliases\":[\"g\"]}]}");
        SpecificCompiler compiler = new SpecificCompiler(s);
        compiler.setStringType(GenericData.StringType.valueOf((String)"String"));
        Collection outputs = compiler.compile();
        Assertions.assertEquals((int)1, (int)outputs.size());
        SpecificCompiler.OutputFile o = (SpecificCompiler.OutputFile)outputs.iterator().next();
        Assertions.assertEquals((Object)o.path, (Object)"X.java");
        Assertions.assertTrue((boolean)o.contents.contains("[\\\"Y\\\"]"));
        Assertions.assertTrue((boolean)o.contents.contains("[\\\"g\\\"]"));
    }

    public static void assertCompiles(File dstDir, Schema schema, boolean useJavaCompiler) throws IOException {
        Collection outputs = new SpecificCompiler(schema).compile();
        Assertions.assertNotNull((Object)outputs);
        if (useJavaCompiler) {
            TestSpecificCompiler.assertCompilesWithJavaCompiler(dstDir, outputs);
        }
    }

    public static void assertCompiles(File dstDir, Protocol protocol, boolean useJavaCompiler) throws IOException {
        Collection outputs = new SpecificCompiler(protocol).compile();
        Assertions.assertNotNull((Object)outputs);
        if (useJavaCompiler) {
            TestSpecificCompiler.assertCompilesWithJavaCompiler(dstDir, outputs);
        }
    }

    static void assertCompilesWithJavaCompiler(File dstDir, Collection<SpecificCompiler.OutputFile> outputs) throws IOException {
        if (outputs.isEmpty()) {
            return;
        }
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (SpecificCompiler.OutputFile o : outputs) {
            javaFiles.add(o.writeToDestination(null, dstDir));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        JavaCompiler.CompilationTask cTask = compiler.getTask(null, fileManager, null, null, null, fileManager.getJavaFileObjects(javaFiles.toArray(new File[0])));
        Assertions.assertTrue((boolean)cTask.call());
    }

    @Test
    void generateExceptionCodeBlock() throws IOException {
        Collection outputs = new SpecificCompiler(new Schema.Parser().parse(SCHEMA1)).compile();
        Assertions.assertEquals((int)1, (int)outputs.size());
        String contents = ((SpecificCompiler.OutputFile)outputs.iterator().next()).contents;
        Assertions.assertTrue((boolean)contents.contains("private java.net.URI"));
        Assertions.assertTrue((boolean)contents.contains("catch (java.net.URISyntaxException e)"));
        Assertions.assertTrue((boolean)contents.contains("private java.net.URL"));
        Assertions.assertTrue((boolean)contents.contains("catch (java.net.MalformedURLException e)"));
    }
}

