/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.ipc.LocalTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Mail;
import org.apache.avro.test.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcPluginOrdering {
    private static AtomicInteger orderCounter = new AtomicInteger();

    @Test
    void rpcPluginOrdering() throws Exception {
        OrderPlugin plugin = new OrderPlugin();
        SpecificResponder responder = new SpecificResponder(Mail.class, (Object)new TestMailImpl());
        SpecificRequestor requestor = new SpecificRequestor(Mail.class, (Transceiver)new LocalTransceiver((Responder)responder));
        responder.addRPCPlugin((RPCPlugin)plugin);
        requestor.addRPCPlugin((RPCPlugin)plugin);
        Mail client = (Mail)SpecificRequestor.getClient(Mail.class, (SpecificRequestor)requestor);
        Message message = this.createTestMessage();
        client.send(message);
    }

    private Message createTestMessage() {
        Message message = Message.newBuilder().setTo("me@test.com").setFrom("you@test.com").setBody("plugin testing").build();
        return message;
    }

    private static class TestMailImpl
    implements Mail {
        private TestMailImpl() {
        }

        @Override
        public String send(Message message) {
            return "Received";
        }

        @Override
        public void fireandforget(Message message) {
        }
    }

    public class OrderPlugin
    extends RPCPlugin {
        public void clientStartConnect(RPCContext context) {
            Assertions.assertEquals((int)0, (int)orderCounter.getAndIncrement());
        }

        public void clientSendRequest(RPCContext context) {
            Assertions.assertEquals((int)1, (int)orderCounter.getAndIncrement());
        }

        public void clientReceiveResponse(RPCContext context) {
            Assertions.assertEquals((int)6, (int)orderCounter.getAndIncrement());
        }

        public void clientFinishConnect(RPCContext context) {
            Assertions.assertEquals((int)5, (int)orderCounter.getAndIncrement());
        }

        public void serverConnecting(RPCContext context) {
            Assertions.assertEquals((int)2, (int)orderCounter.getAndIncrement());
        }

        public void serverReceiveRequest(RPCContext context) {
            Assertions.assertEquals((int)3, (int)orderCounter.getAndIncrement());
        }

        public void serverSendResponse(RPCContext context) {
            Assertions.assertEquals((int)4, (int)orderCounter.getAndIncrement());
        }
    }
}

