/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import org.apache.avro.ipc.stats.FakeTicks;
import org.apache.avro.ipc.stats.Stopwatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStopwatch {
    @Test
    void normal() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        f.passTime(10L);
        s.start();
        f.passTime(20L);
        Assertions.assertEquals((long)20L, (long)s.elapsedNanos());
        f.passTime(40L);
        s.stop();
        f.passTime(80L);
        Assertions.assertEquals((long)60L, (long)s.elapsedNanos());
    }

    @Test
    void notStarted1() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            FakeTicks f = new FakeTicks();
            Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
            s.elapsedNanos();
        });
    }

    @Test
    void notStarted2() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            FakeTicks f = new FakeTicks();
            Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
            s.stop();
        });
    }

    @Test
    void twiceStarted() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            FakeTicks f = new FakeTicks();
            Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
            s.start();
            s.start();
        });
    }

    @Test
    void twiceStopped() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            FakeTicks f = new FakeTicks();
            Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
            s.start();
            s.stop();
            s.stop();
        });
    }

    @Test
    void systemStopwatch() {
        Stopwatch s = new Stopwatch(Stopwatch.SYSTEM_TICKS);
        s.start();
        s.stop();
        Assertions.assertTrue((s.elapsedNanos() >= 0L ? 1 : 0) != 0);
    }
}

