/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.message;

import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.compiler.schema.evolve.NestedEvolve1;
import org.apache.avro.compiler.schema.evolve.NestedEvolve2;
import org.apache.avro.compiler.schema.evolve.NestedEvolve3;
import org.apache.avro.compiler.schema.evolve.TestRecord2;
import org.apache.avro.compiler.schema.evolve.TestRecord3;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomSchemaStore {
    private BinaryMessageDecoder<NestedEvolve1> decoder = NestedEvolve1.createDecoder(new CustomSchemaStore());

    @Test
    void compatibleReadWithSchemaFromSchemaStore() throws Exception {
        NestedEvolve2.Builder rootBuilder = NestedEvolve2.newBuilder().setRootName("RootName");
        rootBuilder.setNested(TestRecord2.newBuilder().setName("Name").setValue(1L).setData("Data").build());
        ByteBuffer nestedEvolve2Buffer = rootBuilder.build().toByteBuffer();
        NestedEvolve1 nestedEvolve1 = (NestedEvolve1)((Object)this.decoder.decode(nestedEvolve2Buffer));
        Assertions.assertEquals((Object)nestedEvolve1.getRootName(), (Object)"RootName");
        Assertions.assertEquals((Object)nestedEvolve1.getNested().getName(), (Object)"Name");
        Assertions.assertEquals((long)nestedEvolve1.getNested().getValue(), (long)1L);
    }

    @Test
    void incompatibleReadWithSchemaFromSchemaStore() throws Exception {
        Assertions.assertThrows(MissingSchemaException.class, () -> {
            NestedEvolve3.Builder rootBuilder = NestedEvolve3.newBuilder().setRootName("RootName");
            rootBuilder.setNested(TestRecord3.newBuilder().setName("Name").setData("Data").build());
            ByteBuffer nestedEvolve3Buffer = rootBuilder.build().toByteBuffer();
            this.decoder.decode(nestedEvolve3Buffer);
        });
    }

    static class CustomSchemaStore
    implements SchemaStore {
        SchemaStore.Cache cache = new SchemaStore.Cache();

        CustomSchemaStore() {
            this.cache.addSchema(NestedEvolve1.getClassSchema());
            this.cache.addSchema(NestedEvolve2.getClassSchema());
        }

        public Schema findByFingerprint(long fingerprint) {
            return this.cache.findByFingerprint(fingerprint);
        }
    }
}

