/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.test.http.HttpMethod;
import org.apache.avro.test.http.HttpRequest;
import org.apache.avro.test.http.HttpURI;
import org.apache.avro.test.http.NetworkType;
import org.apache.avro.test.http.QueryParameter;
import org.apache.avro.test.http.Request;
import org.apache.avro.test.http.UserAgent;
import org.apache.avro.test.nullable.RecordWithNullables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecificBuilderTree {
    private Request.Builder createPartialBuilder() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getConnectionBuilder().setNetworkType(NetworkType.IPv4);
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        if (!requestBuilder.getHttpRequestBuilder().getURIBuilder().hasParameters()) {
            requestBuilder.getHttpRequestBuilder().getURIBuilder().setParameters(new ArrayList<QueryParameter>());
        }
        requestBuilder.getHttpRequestBuilder().getURIBuilder().getParameters().add(QueryParameter.newBuilder().setName("Foo").setValue("Bar").build());
        return requestBuilder;
    }

    @Test
    void failOnIncompleteTree() {
        Assertions.assertThrows(AvroMissingFieldException.class, () -> {
            try {
                this.createPartialBuilder().build();
            }
            catch (AvroMissingFieldException amfe) {
                Assertions.assertEquals((Object)"Field networkAddress type:STRING pos:1 not set and has no default value", (Object)amfe.getMessage());
                Assertions.assertEquals((Object)"Path in schema: --> connection --> networkAddress", (Object)amfe.toString());
                throw amfe;
            }
            Assertions.fail((String)"Should NEVER get here");
        });
    }

    @Test
    void copyBuilder() {
        Request.Builder requestBuilder1 = this.createPartialBuilder();
        Request.Builder requestBuilder2 = Request.newBuilder(requestBuilder1);
        requestBuilder1.getConnectionBuilder().setNetworkAddress("1.1.1.1");
        requestBuilder2.getConnectionBuilder().setNetworkAddress("2.2.2.2");
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setId("Bar");
        Request request1 = requestBuilder1.build();
        Request request2 = requestBuilder2.build();
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request1.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"1.1.1.1", (Object)request1.getConnection().getNetworkAddress());
        Assertions.assertEquals((Object)"Chrome 123", (Object)request1.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request1.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/index.html", (Object)request1.getHttpRequest().getURI().getPath());
        Assertions.assertEquals((int)1, (int)request1.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getName());
        Assertions.assertEquals((Object)"Bar", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getValue());
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request2.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"2.2.2.2", (Object)request2.getConnection().getNetworkAddress());
        Assertions.assertEquals((Object)"Chrome 123", (Object)request2.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request2.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/index.html", (Object)request2.getHttpRequest().getURI().getPath());
        Assertions.assertEquals((int)1, (int)request2.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)"Foo", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getName());
        Assertions.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getValue());
    }

    @Test
    void createBuilderFromInstance() {
        Request.Builder requestBuilder1 = this.createPartialBuilder();
        requestBuilder1.getConnectionBuilder().setNetworkAddress("1.1.1.1");
        Request request1 = requestBuilder1.build();
        Request.Builder requestBuilder2 = Request.newBuilder(request1);
        requestBuilder2.getConnectionBuilder().setNetworkAddress("2.2.2.2");
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setId("Bar");
        requestBuilder2.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.POST);
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Firefox 456");
        Request request2 = requestBuilder2.build();
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request1.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"1.1.1.1", (Object)request1.getConnection().getNetworkAddress());
        Assertions.assertEquals((Object)"Chrome 123", (Object)request1.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request1.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/index.html", (Object)request1.getHttpRequest().getURI().getPath());
        Assertions.assertEquals((int)1, (int)request1.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getName());
        Assertions.assertEquals((Object)"Bar", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getValue());
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request2.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"2.2.2.2", (Object)request2.getConnection().getNetworkAddress());
        Assertions.assertEquals((Object)"Firefox 456", (Object)request2.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((Object)((Object)HttpMethod.POST), (Object)((Object)request2.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/index.html", (Object)request2.getHttpRequest().getURI().getPath());
        Assertions.assertEquals((int)1, (int)request2.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)"Foo", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getName());
        Assertions.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getValue());
    }

    private Request.Builder createLastOneTestsBuilder() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getConnectionBuilder().setNetworkType(NetworkType.IPv4).setNetworkAddress("1.1.1.1");
        return requestBuilder;
    }

    @Test
    void lastOneWins_Setter() {
        Request.Builder requestBuilder = this.createLastOneTestsBuilder();
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        HttpRequest httpRequest = HttpRequest.newBuilder().setUserAgent(new UserAgent("Bar", "Firefox 321")).setURI(HttpURI.newBuilder().setMethod(HttpMethod.POST).setPath("/login.php").build()).build();
        Request request = requestBuilder.setHttpRequest(httpRequest).build();
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"1.1.1.1", (Object)request.getConnection().getNetworkAddress());
        Assertions.assertEquals((int)0, (int)request.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)"Firefox 321", (Object)request.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Bar", (Object)request.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((Object)((Object)HttpMethod.POST), (Object)((Object)request.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/login.php", (Object)request.getHttpRequest().getURI().getPath());
    }

    @Test
    void lastOneWins_Builder() {
        Request.Builder requestBuilder = this.createLastOneTestsBuilder();
        HttpRequest httpRequest = HttpRequest.newBuilder().setUserAgent(new UserAgent("Bar", "Firefox 321")).setURI(HttpURI.newBuilder().setMethod(HttpMethod.POST).setPath("/login.php").build()).build();
        requestBuilder.setHttpRequest(httpRequest);
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        Request request = requestBuilder.build();
        Assertions.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request.getConnection().getNetworkType()));
        Assertions.assertEquals((Object)"1.1.1.1", (Object)request.getConnection().getNetworkAddress());
        Assertions.assertEquals((Object)"Chrome 123", (Object)request.getHttpRequest().getUserAgent().getUseragent());
        Assertions.assertEquals((Object)"Foo", (Object)request.getHttpRequest().getUserAgent().getId());
        Assertions.assertEquals((int)0, (int)request.getHttpRequest().getURI().getParameters().size());
        Assertions.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request.getHttpRequest().getURI().getMethod()));
        Assertions.assertEquals((Object)"/index.html", (Object)request.getHttpRequest().getURI().getPath());
    }

    @Test
    void copyBuilderWithNullables() {
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder();
        Assertions.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assertions.assertFalse((boolean)builder2.hasNullableRecord());
        Assertions.assertFalse((boolean)builder2.hasNullableString());
        Assertions.assertFalse((boolean)builder2.hasNullableLong());
        Assertions.assertFalse((boolean)builder2.hasNullableInt());
        Assertions.assertFalse((boolean)builder2.hasNullableMap());
        Assertions.assertFalse((boolean)builder2.hasNullableArray());
        RecordWithNullables.Builder builderCopy = RecordWithNullables.newBuilder(builder2);
        Assertions.assertFalse((boolean)builderCopy.hasNullableRecordBuilder());
        Assertions.assertFalse((boolean)builderCopy.hasNullableRecord());
        Assertions.assertFalse((boolean)builderCopy.hasNullableString());
        Assertions.assertFalse((boolean)builderCopy.hasNullableLong());
        Assertions.assertFalse((boolean)builderCopy.hasNullableInt());
        Assertions.assertFalse((boolean)builderCopy.hasNullableMap());
        Assertions.assertFalse((boolean)builderCopy.hasNullableArray());
        builderCopy.getNullableRecordBuilder();
    }

    @Test
    void copyBuilderWithNullablesAndSetToNull() {
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder();
        Assertions.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assertions.assertFalse((boolean)builder2.hasNullableRecord());
        Assertions.assertFalse((boolean)builder2.hasNullableString());
        Assertions.assertFalse((boolean)builder2.hasNullableLong());
        Assertions.assertFalse((boolean)builder2.hasNullableInt());
        Assertions.assertFalse((boolean)builder2.hasNullableMap());
        Assertions.assertFalse((boolean)builder2.hasNullableArray());
        builder2.setNullableRecordBuilder(null);
        builder2.setNullableRecord(null);
        builder2.setNullableString(null);
        builder2.setNullableLong(null);
        builder2.setNullableInt(null);
        builder2.setNullableMap(null);
        builder2.setNullableArray(null);
        Assertions.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assertions.assertTrue((boolean)builder2.hasNullableRecord());
        Assertions.assertTrue((boolean)builder2.hasNullableString());
        Assertions.assertTrue((boolean)builder2.hasNullableLong());
        Assertions.assertTrue((boolean)builder2.hasNullableInt());
        Assertions.assertTrue((boolean)builder2.hasNullableMap());
        Assertions.assertTrue((boolean)builder2.hasNullableArray());
        builder2.getNullableRecordBuilder();
        Assertions.assertTrue((boolean)builder2.hasNullableRecordBuilder());
        Assertions.assertFalse((boolean)builder2.hasNullableRecord());
        RecordWithNullables.Builder builderCopy = RecordWithNullables.newBuilder(builder2);
        Assertions.assertTrue((boolean)builder2.hasNullableRecordBuilder());
        Assertions.assertFalse((boolean)builder2.hasNullableRecord());
        Assertions.assertTrue((boolean)builder2.hasNullableString());
        Assertions.assertTrue((boolean)builder2.hasNullableLong());
        Assertions.assertTrue((boolean)builder2.hasNullableInt());
        Assertions.assertTrue((boolean)builder2.hasNullableMap());
        Assertions.assertTrue((boolean)builder2.hasNullableArray());
    }

    @Test
    void getBuilderForRecordWithNullRecord() {
        RecordWithNullables recordWithNullables = RecordWithNullables.newBuilder().build();
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder(recordWithNullables);
        builder2.getNullableRecordBuilder();
    }

    @Test
    void getBuilderForNullRecord() {
        RecordWithNullables.newBuilder((RecordWithNullables)null);
    }

    @Test
    void getBuilderForNullBuilder() {
        RecordWithNullables.newBuilder((RecordWithNullables.Builder)null);
    }

    @Test
    void validateBrowsingOptionals() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123");
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        Request request = requestBuilder.build();
        Assertions.assertEquals((Object)"Chrome 123", (Object)Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalUserAgent).flatMap(UserAgent::getOptionalUseragent).orElse("UNKNOWN"));
        Assertions.assertFalse((boolean)Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalUserAgent).flatMap(UserAgent::getOptionalId).isPresent());
        Assertions.assertEquals((Object)((Object)HttpMethod.GET), Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalURI).flatMap(HttpURI::getOptionalMethod).orElse(null));
        Assertions.assertEquals((Object)"/index.html", Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalURI).flatMap(HttpURI::getOptionalPath).orElse(null));
    }
}

