/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.avro.FooBarSpecificRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import test.StringablesRecord;

public class TestSpecificDatumReader {
    public static byte[] serializeRecord(FooBarSpecificRecord fooBarSpecificRecord) throws IOException {
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(FooBarSpecificRecord.SCHEMA$);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write((Object)fooBarSpecificRecord, (Encoder)encoder);
        encoder.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] serializeRecord(StringablesRecord stringablesRecord) throws IOException {
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(StringablesRecord.SCHEMA$);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write((Object)stringablesRecord, (Encoder)encoder);
        encoder.flush();
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    void read() throws IOException {
        FooBarSpecificRecord.Builder newBuilder = FooBarSpecificRecord.newBuilder();
        newBuilder.setId(42);
        newBuilder.setName("foo");
        newBuilder.setNicknames(Collections.singletonList("bar"));
        newBuilder.setRelatedids(Arrays.asList(1, 2, 3));
        FooBarSpecificRecord specificRecord = newBuilder.build();
        byte[] recordBytes = TestSpecificDatumReader.serializeRecord(specificRecord);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(recordBytes, null);
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(FooBarSpecificRecord.SCHEMA$);
        FooBarSpecificRecord deserialized = new FooBarSpecificRecord();
        specificDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)((Object)specificRecord), (Object)((Object)deserialized));
    }

    @Test
    void stringables() throws IOException {
        StringablesRecord.Builder newBuilder = StringablesRecord.newBuilder();
        newBuilder.setValue(new BigDecimal("42.11"));
        HashMap<String, BigDecimal> mapWithBigDecimalElements = new HashMap<String, BigDecimal>();
        mapWithBigDecimalElements.put("test", new BigDecimal("11.11"));
        newBuilder.setMapWithBigDecimalElements(mapWithBigDecimalElements);
        HashMap<BigInteger, String> mapWithBigIntKeys = new HashMap<BigInteger, String>();
        mapWithBigIntKeys.put(BigInteger.ONE, "test");
        newBuilder.setMapWithBigIntKeys(mapWithBigIntKeys);
        StringablesRecord stringablesRecord = newBuilder.build();
        byte[] recordBytes = TestSpecificDatumReader.serializeRecord(stringablesRecord);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(recordBytes, null);
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(StringablesRecord.SCHEMA$);
        StringablesRecord deserialized = new StringablesRecord();
        specificDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)((Object)stringablesRecord), (Object)((Object)deserialized));
    }
}

