/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.test.errors.TestError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecificErrorBuilder {
    @Test
    void specificErrorBuilder() {
        TestError.Builder testErrorBuilder = TestError.newBuilder().setValue("value").setCause(new NullPointerException()).setMessage$("message$");
        Assertions.assertTrue((boolean)testErrorBuilder.hasValue());
        Assertions.assertNotNull((Object)testErrorBuilder.getValue());
        Assertions.assertTrue((boolean)testErrorBuilder.hasCause());
        Assertions.assertNotNull((Object)testErrorBuilder.getCause());
        Assertions.assertTrue((boolean)testErrorBuilder.hasMessage$());
        Assertions.assertNotNull((Object)testErrorBuilder.getMessage$());
        TestError testError = testErrorBuilder.build();
        Assertions.assertEquals((Object)"value", (Object)testError.getValue());
        Assertions.assertEquals((Object)"value", (Object)testError.getMessage());
        Assertions.assertEquals((Object)"message$", (Object)testError.getMessage$());
        Assertions.assertEquals((Object)((Object)testErrorBuilder), (Object)((Object)TestError.newBuilder(testErrorBuilder)));
        Assertions.assertEquals((Object)((Object)testErrorBuilder), (Object)((Object)TestError.newBuilder(testError)));
        TestError error = new TestError("value", new NullPointerException());
        error.setMessage$("message");
        Assertions.assertEquals((Object)((Object)error), (Object)((Object)TestError.newBuilder().setValue("value").setCause(new NullPointerException()).setMessage$("message").build()));
        testErrorBuilder.clearValue();
        Assertions.assertFalse((boolean)testErrorBuilder.hasValue());
        Assertions.assertNull((Object)testErrorBuilder.getValue());
        testErrorBuilder.clearCause();
        Assertions.assertFalse((boolean)testErrorBuilder.hasCause());
        Assertions.assertNull((Object)testErrorBuilder.getCause());
        testErrorBuilder.clearMessage$();
        Assertions.assertFalse((boolean)testErrorBuilder.hasMessage$());
        Assertions.assertNull((Object)testErrorBuilder.getMessage$());
    }

    @Test
    void attemptToSetNonNullableFieldToNull() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> TestError.newBuilder().setMessage$(null));
    }
}

