/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Foo;
import org.apache.avro.Interop;
import org.apache.avro.Kind;
import org.apache.avro.MD5;
import org.apache.avro.Node;
import org.apache.avro.ipc.specific.PageView;
import org.apache.avro.ipc.specific.Person;
import org.apache.avro.ipc.specific.ProductPage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestSpecificRecordBuilder {
    @Test
    void specificBuilder() {
        Person.Builder builder2 = Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setState("CA");
        Assertions.assertTrue((boolean)builder2.hasName());
        Assertions.assertEquals((Object)"James Gosling", (Object)builder2.getName());
        Assertions.assertTrue((boolean)builder2.hasYearOfBirth());
        Assertions.assertEquals((int)1955, (int)builder2.getYearOfBirth());
        Assertions.assertFalse((boolean)builder2.hasCountry());
        Assertions.assertNull((Object)builder2.getCountry());
        Assertions.assertTrue((boolean)builder2.hasState());
        Assertions.assertEquals((Object)"CA", (Object)builder2.getState());
        Assertions.assertFalse((boolean)builder2.hasFriends());
        Assertions.assertNull(builder2.getFriends());
        Assertions.assertFalse((boolean)builder2.hasLanguages());
        Assertions.assertNull(builder2.getLanguages());
        Person person = builder2.build();
        Assertions.assertEquals((Object)"James Gosling", (Object)person.getName());
        Assertions.assertEquals((int)1955, (int)person.getYearOfBirth());
        Assertions.assertEquals((Object)"US", (Object)person.getCountry());
        Assertions.assertEquals((Object)"CA", (Object)person.getState());
        Assertions.assertNotNull(person.getFriends());
        Assertions.assertEquals((int)0, (int)person.getFriends().size());
        Assertions.assertNotNull(person.getLanguages());
        Assertions.assertEquals((int)2, (int)person.getLanguages().size());
        Assertions.assertEquals((Object)"English", (Object)person.getLanguages().get(0));
        Assertions.assertEquals((Object)"Java", (Object)person.getLanguages().get(1));
        Assertions.assertEquals((Object)((Object)builder2), (Object)((Object)Person.newBuilder(builder2)));
        Assertions.assertEquals((Object)((Object)person), (Object)((Object)Person.newBuilder(person).build()));
        Person.Builder builderCopy = Person.newBuilder(person);
        Assertions.assertEquals((Object)"James Gosling", (Object)builderCopy.getName());
        Assertions.assertEquals((int)1955, (int)builderCopy.getYearOfBirth());
        Assertions.assertEquals((Object)"US", (Object)builderCopy.getCountry());
        Assertions.assertEquals((Object)"CA", (Object)builderCopy.getState());
        Assertions.assertNotNull(builderCopy.getFriends());
        Assertions.assertEquals((int)0, (int)builderCopy.getFriends().size());
        builderCopy.clearFriends().clearCountry();
        Assertions.assertFalse((boolean)builderCopy.hasFriends());
        Assertions.assertFalse((boolean)builderCopy.hasCountry());
        Assertions.assertNull(builderCopy.getFriends());
        Assertions.assertNull((Object)builderCopy.getCountry());
        Person person2 = builderCopy.build();
        Assertions.assertNotNull(person2.getFriends());
        Assertions.assertTrue((boolean)person2.getFriends().isEmpty());
    }

    @Test
    void unions() {
        long datetime = 1234L;
        String product = "widget";
        PageView p = PageView.newBuilder().setDatetime(1234L).setPageContext((Object)ProductPage.newBuilder().setProduct(product).build()).build();
        Assertions.assertEquals((long)datetime, (long)p.getDatetime());
        Assertions.assertEquals(ProductPage.class, p.getPageContext().getClass());
        Assertions.assertEquals((Object)product, (Object)((ProductPage)((Object)p.getPageContext())).getProduct());
        PageView p2 = PageView.newBuilder(p).build();
        Assertions.assertEquals((long)datetime, (long)p2.getDatetime());
        Assertions.assertEquals(ProductPage.class, p2.getPageContext().getClass());
        Assertions.assertEquals((Object)product, (Object)((ProductPage)((Object)p2.getPageContext())).getProduct());
        Assertions.assertEquals((Object)((Object)p), (Object)((Object)p2));
    }

    @Test
    void interop() {
        Interop interop = Interop.newBuilder().setNullField(null).setArrayField(Arrays.asList(3.14159265, 6.022)).setBoolField(true).setBytesField(ByteBuffer.allocate(4).put(new byte[]{3, 2, 1, 0})).setDoubleField(1.41421).setEnumField(Kind.C).setFixedField(new MD5(new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3})).setFloatField(1.61803f).setIntField(64).setLongField(1024L).setMapField(Collections.singletonMap("Foo1", new Foo())).setRecordField(new Node()).setStringField("MyInterop").setUnionField(2.71828).build();
        Interop copy = Interop.newBuilder(interop).build();
        Assertions.assertEquals((int)interop.getArrayField().size(), (int)copy.getArrayField().size());
        Assertions.assertEquals(interop.getArrayField(), copy.getArrayField());
        Assertions.assertEquals((Object)interop.getBoolField(), (Object)copy.getBoolField());
        Assertions.assertEquals((Object)interop.getBytesField(), (Object)copy.getBytesField());
        Assertions.assertEquals((double)interop.getDoubleField(), (double)copy.getDoubleField(), (double)0.001);
        Assertions.assertEquals((Object)((Object)interop.getEnumField()), (Object)((Object)copy.getEnumField()));
        Assertions.assertEquals((Object)((Object)interop.getFixedField()), (Object)((Object)copy.getFixedField()));
        Assertions.assertEquals((double)interop.getFloatField(), (double)copy.getFloatField(), (double)0.001);
        Assertions.assertEquals((int)interop.getIntField(), (int)copy.getIntField());
        Assertions.assertEquals((long)interop.getLongField(), (long)copy.getLongField());
        Assertions.assertEquals(interop.getMapField(), copy.getMapField());
        Assertions.assertEquals((Object)((Object)interop.getRecordField()), (Object)((Object)copy.getRecordField()));
        Assertions.assertEquals((Object)interop.getStringField(), (Object)copy.getStringField());
        Assertions.assertEquals((Object)interop.getUnionField(), (Object)copy.getUnionField());
        Assertions.assertEquals((Object)((Object)interop), (Object)((Object)copy));
    }

    @Test
    void attemptToSetNonNullableFieldToNull() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> Person.newBuilder().setName(null));
    }

    @Test
    void buildWithoutSettingRequiredFields1() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> Person.newBuilder().build());
    }

    @Test
    void buildWithoutSettingRequiredFields2() {
        try {
            Person.newBuilder().setYearOfBirth(1900).setState("MA").build();
            Assertions.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("name"));
        }
    }

    @Test
    void buildWithoutSettingRequiredFields3() {
        try {
            Person.newBuilder().setName("Anon").setState("CA").build();
            Assertions.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("year_of_birth"));
        }
    }

    @Disabled
    @Test
    void builderPerformance() {
        int count = 1000000;
        ArrayList<Person> friends = new ArrayList<Person>(0);
        ArrayList<String> languages = new ArrayList<String>(Arrays.asList("English", "Java"));
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setCountry("US").setState("CA").setFriends(friends).setLanguages(languages).build();
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }

    @Disabled
    @Test
    void builderPerformanceWithDefaultValues() {
        int count = 1000000;
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setState("CA").build();
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }

    @Disabled
    @Test
    void manualBuildPerformance() {
        int count = 1000000;
        ArrayList<Person> friends = new ArrayList<Person>(0);
        ArrayList<String> languages = new ArrayList<String>(Arrays.asList("English", "Java"));
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person person = new Person();
            person.setName("James Gosling");
            person.setYearOfBirth(1955);
            person.setState("CA");
            person.setCountry("US");
            person.setFriends(friends);
            person.setLanguages(languages);
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }
}

