/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.http;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.avro.test.http.HttpURI;
import org.apache.avro.test.http.UserAgent;

@AvroGenerated
public class HttpRequest
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3019564634348882510L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HttpRequest\",\"namespace\":\"org.apache.avro.test.http\",\"fields\":[{\"name\":\"userAgent\",\"type\":{\"type\":\"record\",\"name\":\"UserAgent\",\"fields\":[{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"useragent\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}},{\"name\":\"URI\",\"type\":{\"type\":\"record\",\"name\":\"HttpURI\",\"fields\":[{\"name\":\"method\",\"type\":{\"type\":\"enum\",\"name\":\"HttpMethod\",\"symbols\":[\"GET\",\"POST\"]}},{\"name\":\"path\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"QueryParameter\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]}]}},\"default\":[]}]}}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HttpRequest> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HttpRequest> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private UserAgent userAgent;
    private HttpURI URI;
    private static final DatumWriter<HttpRequest> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HttpRequest> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HttpRequest> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HttpRequest> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HttpRequest> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HttpRequest fromByteBuffer(ByteBuffer b) throws IOException {
        return (HttpRequest)((Object)DECODER.decode(b));
    }

    public HttpRequest() {
    }

    public HttpRequest(UserAgent userAgent, HttpURI URI2) {
        this.userAgent = userAgent;
        this.URI = URI2;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.userAgent;
            }
            case 1: {
                return this.URI;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.userAgent = (UserAgent)((Object)value$);
                break;
            }
            case 1: {
                this.URI = (HttpURI)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public Optional<UserAgent> getOptionalUserAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public void setUserAgent(UserAgent value2) {
        this.userAgent = value2;
    }

    public HttpURI getURI() {
        return this.URI;
    }

    public Optional<HttpURI> getOptionalURI() {
        return Optional.ofNullable(this.URI);
    }

    public void setURI(HttpURI value2) {
        this.URI = value2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HttpRequest other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        this.userAgent.customEncode(out);
        this.URI.customEncode(out);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (this.userAgent == null) {
                this.userAgent = new UserAgent();
            }
            this.userAgent.customDecode(in);
            if (this.URI == null) {
                this.URI = new HttpURI();
            }
            this.URI.customDecode(in);
        } else {
            block4: for (int i = 0; i < 2; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (this.userAgent == null) {
                            this.userAgent = new UserAgent();
                        }
                        this.userAgent.customDecode(in);
                        continue block4;
                    }
                    case 1: {
                        if (this.URI == null) {
                            this.URI = new HttpURI();
                        }
                        this.URI.customDecode(in);
                        continue block4;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HttpRequest>
    implements RecordBuilder<HttpRequest> {
        private UserAgent userAgent;
        private UserAgent.Builder userAgentBuilder;
        private HttpURI URI;
        private HttpURI.Builder URIBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.userAgent))) {
                this.userAgent = (UserAgent)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.userAgent));
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (other.hasUserAgentBuilder()) {
                this.userAgentBuilder = UserAgent.newBuilder(other.getUserAgentBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.URI))) {
                this.URI = (HttpURI)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.URI));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (other.hasURIBuilder()) {
                this.URIBuilder = HttpURI.newBuilder(other.getURIBuilder());
            }
        }

        private Builder(HttpRequest other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.userAgent))) {
                this.userAgent = (UserAgent)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.userAgent));
                this.fieldSetFlags()[0] = true;
            }
            this.userAgentBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.URI))) {
                this.URI = (HttpURI)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.URI));
                this.fieldSetFlags()[1] = true;
            }
            this.URIBuilder = null;
        }

        public UserAgent getUserAgent() {
            return this.userAgent;
        }

        public Optional<UserAgent> getOptionalUserAgent() {
            return Optional.ofNullable(this.userAgent);
        }

        public Builder setUserAgent(UserAgent value2) {
            this.validate(this.fields()[0], (Object)value2);
            this.userAgentBuilder = null;
            this.userAgent = value2;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasUserAgent() {
            return this.fieldSetFlags()[0];
        }

        public UserAgent.Builder getUserAgentBuilder() {
            if (this.userAgentBuilder == null) {
                if (this.hasUserAgent()) {
                    this.setUserAgentBuilder(UserAgent.newBuilder(this.userAgent));
                } else {
                    this.setUserAgentBuilder(UserAgent.newBuilder());
                }
            }
            return this.userAgentBuilder;
        }

        public Builder setUserAgentBuilder(UserAgent.Builder value2) {
            this.clearUserAgent();
            this.userAgentBuilder = value2;
            return this;
        }

        public boolean hasUserAgentBuilder() {
            return this.userAgentBuilder != null;
        }

        public Builder clearUserAgent() {
            this.userAgent = null;
            this.userAgentBuilder = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public HttpURI getURI() {
            return this.URI;
        }

        public Optional<HttpURI> getOptionalURI() {
            return Optional.ofNullable(this.URI);
        }

        public Builder setURI(HttpURI value2) {
            this.validate(this.fields()[1], (Object)value2);
            this.URIBuilder = null;
            this.URI = value2;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasURI() {
            return this.fieldSetFlags()[1];
        }

        public HttpURI.Builder getURIBuilder() {
            if (this.URIBuilder == null) {
                if (this.hasURI()) {
                    this.setURIBuilder(HttpURI.newBuilder(this.URI));
                } else {
                    this.setURIBuilder(HttpURI.newBuilder());
                }
            }
            return this.URIBuilder;
        }

        public Builder setURIBuilder(HttpURI.Builder value2) {
            this.clearURI();
            this.URIBuilder = value2;
            return this;
        }

        public boolean hasURIBuilder() {
            return this.URIBuilder != null;
        }

        public Builder clearURI() {
            this.URI = null;
            this.URIBuilder = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public HttpRequest build() {
            try {
                HttpRequest record = new HttpRequest();
                if (this.userAgentBuilder != null) {
                    try {
                        record.userAgent = this.userAgentBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("userAgent"));
                        throw e;
                    }
                } else {
                    record.userAgent = this.fieldSetFlags()[0] ? this.userAgent : (UserAgent)((Object)this.defaultValue(this.fields()[0]));
                }
                if (this.URIBuilder != null) {
                    try {
                        record.URI = this.URIBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("URI"));
                        throw e;
                    }
                } else {
                    record.URI = this.fieldSetFlags()[1] ? this.URI : (HttpURI)((Object)this.defaultValue(this.fields()[1]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

