/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSerialization<T>
extends Configured
implements Serialization<AvroWrapper<T>> {
    private static final DecoderFactory FACTORY = DecoderFactory.get();

    public boolean accept(Class<?> c) {
        return AvroWrapper.class.isAssignableFrom(c);
    }

    public Deserializer<AvroWrapper<T>> getDeserializer(Class<AvroWrapper<T>> c) {
        boolean isKey = AvroKey.class.isAssignableFrom(c);
        Schema schema = isKey ? Pair.getKeySchema(AvroJob.getMapOutputSchema(this.getConf())) : Pair.getValueSchema(AvroJob.getMapOutputSchema(this.getConf()));
        ReflectDatumReader datumReader = this.getConf().getBoolean("avro.map.output.is.reflect", false) ? new ReflectDatumReader(schema) : new SpecificDatumReader(schema);
        return new AvroWrapperDeserializer(datumReader, isKey);
    }

    public Serializer<AvroWrapper<T>> getSerializer(Class<AvroWrapper<T>> c) {
        boolean isFinalOutput = c.equals(AvroWrapper.class);
        Schema schema = isFinalOutput ? AvroJob.getOutputSchema(this.getConf()) : (AvroKey.class.isAssignableFrom(c) ? Pair.getKeySchema(AvroJob.getMapOutputSchema(this.getConf())) : Pair.getValueSchema(AvroJob.getMapOutputSchema(this.getConf())));
        return new AvroWrapperSerializer(new ReflectDatumWriter(schema));
    }

    private class AvroWrapperSerializer
    implements Serializer<AvroWrapper<T>> {
        private DatumWriter<T> writer;
        private OutputStream out;
        private BinaryEncoder encoder;

        public AvroWrapperSerializer(DatumWriter<T> writer) {
            this.writer = writer;
        }

        public void open(OutputStream out) {
            this.out = out;
            this.encoder = new EncoderFactory().configureBlockSize(512).binaryEncoder(out, null);
        }

        public void serialize(AvroWrapper<T> wrapper) throws IOException {
            this.writer.write(wrapper.datum(), (Encoder)this.encoder);
            this.encoder.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private class AvroWrapperDeserializer
    implements Deserializer<AvroWrapper<T>> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private boolean isKey;

        public AvroWrapperDeserializer(DatumReader<T> reader, boolean isKey) {
            this.reader = reader;
            this.isKey = isKey;
        }

        public void open(InputStream in) {
            this.decoder = FACTORY.directBinaryDecoder(in, this.decoder);
        }

        public AvroWrapper<T> deserialize(AvroWrapper<T> wrapper) throws IOException {
            Object datum = this.reader.read(wrapper == null ? null : wrapper.datum(), (Decoder)this.decoder);
            if (wrapper == null) {
                wrapper = this.isKey ? new AvroKey<Object>(datum) : new AvroValue<Object>(datum);
            } else {
                wrapper.datum(datum);
            }
            return wrapper;
        }

        public void close() throws IOException {
            this.decoder.inputStream().close();
        }
    }
}

