/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DstPathParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.mortbay.util.ajax.JSON;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final String SCHEME = "webhdfs";
    public static final String PATH_PREFIX = "webhdfs";
    private static final KerberosUgiAuthenticator AUTH = new KerberosUgiAuthenticator();
    public static final Text TOKEN_KIND = new Text("WEBHDFS delegation");
    private static final DelegationTokenRenewer<WebHdfsFileSystem> dtRenewer = new DelegationTokenRenewer(WebHdfsFileSystem.class);
    private final UserGroupInformation ugi;
    private InetSocketAddress nnAddr;
    private Token<?> delegationToken;
    private Token<?> renewToken;
    private final AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
    private Path workingDir;
    private static final DtSelector webhdfspTokenSelector;

    public WebHdfsFileSystem() {
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        this.nnAddr = NetUtils.createSocketAddr(uri.getAuthority(), this.getDefaultPort());
        this.workingDir = this.getHomeDirectory();
        if (UserGroupInformation.isSecurityEnabled()) {
            this.initDelegationToken();
        }
    }

    protected void initDelegationToken() throws IOException {
        Text serviceName = SecurityUtil.buildTokenService(this.nnAddr);
        Token<Object> token = webhdfspTokenSelector.selectToken(serviceName, this.ugi.getTokens());
        if (token == null) {
            token = DelegationTokenSelector.selectHdfsDelegationToken(this.nnAddr, this.ugi, this.getConf());
        }
        boolean createdToken = false;
        if (token == null) {
            token = this.getDelegationToken(null);
            boolean bl = createdToken = token != null;
        }
        if (token != null) {
            this.setDelegationToken(token);
            if (createdToken) {
                dtRenewer.addRenewAction(this);
                LOG.debug("Created new DT for " + token.getService());
            } else {
                LOG.debug("Found existing DT for " + token.getService());
            }
        }
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    @Override
    public URI getUri() {
        try {
            return new URI("webhdfs", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.ugi.getShortUserName()));
    }

    @Override
    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public synchronized void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    private static <T> T jsonParse(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("The input stream is null.");
        }
        return (T)JSON.parse(new InputStreamReader(in));
    }

    private static void validateResponse(HttpOpParam.Op op, HttpURLConnection conn) throws IOException {
        int code = conn.getResponseCode();
        if (code != op.getExpectedHttpResponseCode()) {
            Map m;
            try {
                m = (Map)WebHdfsFileSystem.jsonParse(conn.getErrorStream());
            }
            catch (IOException e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            RemoteException re = JsonUtil.toRemoteException(m);
            throw re.unwrapRemoteException(AccessControlException.class, DSQuotaExceededException.class, FileNotFoundException.class, SafeModeException.class, NSQuotaExceededException.class);
        }
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL("http", this.nnAddr.getHostName(), this.nnAddr.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace("url=" + url);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addDt2Query(String query) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            WebHdfsFileSystem webHdfsFileSystem = this;
            synchronized (webHdfsFileSystem) {
                if (this.delegationToken != null) {
                    String encoded = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(encoded);
                }
            }
        }
        return query;
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = "/webhdfs" + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getPath());
        String query = op.toQueryString() + '&' + new UserParam(this.ugi) + Param.toSortedString("&", parameters);
        URL url = this.getNamenodeURL(path, this.addDt2Query(query));
        if (LOG.isTraceEnabled()) {
            LOG.trace("url=" + url);
        }
        return url;
    }

    private HttpURLConnection httpConnect(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        HttpURLConnection conn;
        URL url = this.toUrl(op, fspath, parameters);
        try {
            conn = new AuthenticatedURL(AUTH).openConnection(url, this.authToken);
        }
        catch (AuthenticationException e) {
            throw new IOException("Authentication failed, url=" + url, e);
        }
        try {
            conn.setRequestMethod(op.getType().toString());
            conn.setDoOutput(op.getDoOutput());
            if (op.getDoOutput()) {
                conn.setRequestProperty("Expect", "100-Continue");
                conn.setInstanceFollowRedirects(true);
            }
            conn.connect();
            return conn;
        }
        catch (IOException e) {
            conn.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T run(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        HttpURLConnection conn = this.httpConnect(op, fspath, parameters);
        WebHdfsFileSystem.validateResponse(op, conn);
        try {
            T t = WebHdfsFileSystem.jsonParse(conn.getInputStream());
            return t;
        }
        finally {
            conn.disconnect();
        }
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask(this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        Map json = (Map)this.run(op, f, new Param[0]);
        HdfsFileStatus status = JsonUtil.toFileStatus(json, true);
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.makeQualified(this.getHdfsFileStatus(f), f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getFullPath(parent).makeQualified(this));
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        Map json = (Map)this.run(op, f, new PermissionParam(this.applyUMask(permission)));
        return (Boolean)json.get("boolean");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        Map json = (Map)this.run(op, src, new DstPathParam(this.makeQualified(dst).toUri().getPath()));
        return (Boolean)json.get("boolean");
    }

    @Override
    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        this.run(op, p, new OwnerParam(owner), new GroupParam(group));
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        this.run(op, p, new PermissionParam(permission));
    }

    @Override
    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        Map json = (Map)this.run(op, p, new ReplicationParam(replication));
        return (Boolean)json.get("boolean");
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        this.run(op, p, new ModificationTimeParam(mtime), new AccessTimeParam(atime));
    }

    private FSDataOutputStream write(final HttpOpParam.Op op, final HttpURLConnection conn, int bufferSize) throws IOException {
        return new FSDataOutputStream(new BufferedOutputStream(conn.getOutputStream(), bufferSize), this.statistics){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    WebHdfsFileSystem.validateResponse(op, conn);
                }
            }
        };
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        HttpURLConnection conn = this.httpConnect(op, f, new PermissionParam(this.applyUMask(permission)), new OverwriteParam(overwrite), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize));
        return this.write(op, conn, bufferSize);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        HttpURLConnection conn = this.httpConnect(op, f, new BufferSizeParam(bufferSize));
        return this.write(op, conn, bufferSize);
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        Map json = (Map)this.run(op, f, new RecursiveParam(recursive));
        return (Boolean)json.get("boolean");
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        URL url = this.toUrl(op, f, new BufferSizeParam(buffersize));
        return new FSDataInputStream(new ByteRangeInputStream(url));
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        Map json = (Map)this.run(op, f, new Param[0]);
        Object[] array = (Object[])json.get(HdfsFileStatus.class.getSimpleName());
        FileStatus[] statuses = new FileStatus[array.length];
        for (int i = 0; i < array.length; ++i) {
            Map m = (Map)array[i];
            statuses[i] = this.makeQualified(JsonUtil.toFileStatus(m, false), f);
        }
        return statuses;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
        Map m = (Map)this.run(op, null, new RenewerParam(renewer));
        Token<DelegationTokenIdentifier> token = JsonUtil.toDelegationToken(m);
        SecurityUtil.setTokenService(token, this.nnAddr);
        return token;
    }

    @Override
    public Token<?> getRenewToken() {
        return this.renewToken;
    }

    @Override
    public synchronized <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.renewToken = token;
        this.delegationToken = new Token<T>(token);
        this.delegationToken.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    private synchronized long renewDelegationToken(Token<?> token) throws IOException {
        this.delegationToken = token;
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        Map m = (Map)this.run(op, null, new Param[0]);
        return (Long)m.get("long");
    }

    private synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        this.delegationToken = token;
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        this.run(op, null, new Param[0]);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        this.statistics.incrementReadOps(1);
        Path p = status.getPath();
        GetOpParam.Op op = GetOpParam.Op.GETFILEBLOCKLOCATIONS;
        Map m = (Map)this.run(op, p, new OffsetParam(offset), new LengthParam(length));
        return DFSUtil.locatedBlocks2Locations(JsonUtil.toLocatedBlocks(m));
    }

    @Override
    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        Map m = (Map)this.run(op, p, new Param[0]);
        return JsonUtil.toContentSummary(m);
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        Map m = (Map)this.run(op, p, new Param[0]);
        return JsonUtil.toMD5MD5CRC32FileChecksum(m);
    }

    static {
        dtRenewer.start();
        webhdfspTokenSelector = new DtSelector();
    }

    public static class DtRenewer
    extends TokenRenewer {
        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(TOKEN_KIND);
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        private static WebHdfsFileSystem getWebHdfs(Token<?> token, Configuration conf) throws IOException, InterruptedException, URISyntaxException {
            InetSocketAddress nnAddr = SecurityUtil.getTokenServiceAddr(token);
            URI uri = DFSUtil.createUri("webhdfs", nnAddr);
            return (WebHdfsFileSystem)FileSystem.get(uri, conf);
        }

        @Override
        public long renew(final Token<?> token, final Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            return ugi.doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    WebHdfsFileSystem webhdfs = DtRenewer.getWebHdfs(token, conf);
                    return webhdfs.renewDelegationToken(token);
                }
            });
        }

        @Override
        public void cancel(final Token<?> token, final Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    WebHdfsFileSystem webhdfs = DtRenewer.getWebHdfs(token, conf);
                    webhdfs.cancelDelegationToken(token);
                    return null;
                }
            });
        }
    }

    private static class DtSelector
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        private DtSelector() {
            super(TOKEN_KIND);
        }
    }
}

