/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.examples.complete.game.utils.WriteToText;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserScore {
    protected static Map<String, WriteToText.FieldFn<KV<String, Integer>>> configureOutput() {
        HashMap<String, WriteToText.FieldFn<KV<String, Integer>>> config = new HashMap<String, WriteToText.FieldFn<KV<String, Integer>>>();
        config.put("user", (c, w) -> (String)((KV)c.element()).getKey());
        config.put("total_score", (c, w) -> (Integer)((KV)c.element()).getValue());
        return config;
    }

    public static void main(String[] args) throws Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)pipeline.apply((PTransform)TextIO.read().from(options.getInput()))).apply("ParseGameEvent", (PTransform)ParDo.of((DoFn)new ParseEventFn()))).apply("ExtractUserScore", (PTransform)new ExtractAndSumScore("user"))).apply("WriteUserScoreSums", new WriteToText(options.getOutput(), UserScore.configureOutput(), false));
        pipeline.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Path to the data file(s) containing game data.")
        @Default.String(value="gs://apache-beam-samples/game/gaming_data*.csv")
        public String getInput();

        public void setInput(String var1);

        @Description(value="Path of the file to write to.")
        @Validation.Required
        public String getOutput();

        public void setOutput(String var1);
    }

    public static class ExtractAndSumScore
    extends PTransform<PCollection<GameActionInfo>, PCollection<KV<String, Integer>>> {
        private final String field;

        ExtractAndSumScore(String field) {
            this.field = field;
        }

        public PCollection<KV<String, Integer>> expand(PCollection<GameActionInfo> gameInfo) {
            return (PCollection)((PCollection)gameInfo.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.integers())).via((SerializableFunction & Serializable)gInfo -> KV.of((Object)gInfo.getKey(this.field), (Object)gInfo.getScore())))).apply((PTransform)Sum.integersPerKey());
        }
    }

    static class ParseEventFn
    extends DoFn<String, GameActionInfo> {
        private static final Logger LOG = LoggerFactory.getLogger(ParseEventFn.class);
        private final Counter numParseErrors = Metrics.counter((String)"main", (String)"ParseErrors");

        ParseEventFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String[] components = ((String)c.element()).split(",");
            try {
                String user = components[0].trim();
                String team = components[1].trim();
                Integer score = Integer.parseInt(components[2].trim());
                Long timestamp = Long.parseLong(components[3].trim());
                GameActionInfo gInfo = new GameActionInfo(user, team, score, timestamp);
                c.output((Object)gInfo);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                this.numParseErrors.inc();
                LOG.info("Parse error on " + (String)c.element() + ", " + e.getMessage());
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class GameActionInfo {
        @Nullable
        String user;
        @Nullable
        String team;
        @Nullable
        Integer score;
        @Nullable
        Long timestamp;

        public GameActionInfo() {
        }

        public GameActionInfo(String user, String team, Integer score, Long timestamp) {
            this.user = user;
            this.team = team;
            this.score = score;
            this.timestamp = timestamp;
        }

        public String getUser() {
            return this.user;
        }

        public String getTeam() {
            return this.team;
        }

        public Integer getScore() {
            return this.score;
        }

        public String getKey(String keyname) {
            if (keyname.equals("team")) {
                return this.team;
            }
            return this.user;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }
    }
}

