/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.injector;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.beam.examples.java8.repackaged.com.google.common.base.Preconditions;

public class RetryHttpInitializerWrapper
implements HttpRequestInitializer {
    private static final Logger LOG = Logger.getLogger(RetryHttpInitializerWrapper.class.getName());
    private static final int ONEMINITUES = 60000;
    private final Credential wrappedCredential;
    private final Sleeper sleeper;

    public RetryHttpInitializerWrapper(Credential wrappedCredential) {
        this(wrappedCredential, Sleeper.DEFAULT);
    }

    RetryHttpInitializerWrapper(Credential wrappedCredential, Sleeper sleeper) {
        this.wrappedCredential = Preconditions.checkNotNull(wrappedCredential);
        this.sleeper = sleeper;
    }

    public final void initialize(HttpRequest request) {
        request.setReadTimeout(120000);
        HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper);
        request.setInterceptor((HttpExecuteInterceptor)this.wrappedCredential);
        request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)backoffHandler){
            final /* synthetic */ HttpUnsuccessfulResponseHandler val$backoffHandler;
            {
                this.val$backoffHandler = httpUnsuccessfulResponseHandler;
            }

            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                if (RetryHttpInitializerWrapper.this.wrappedCredential.handleResponse(request, response, supportsRetry)) {
                    return true;
                }
                if (this.val$backoffHandler.handleResponse(request, response, supportsRetry)) {
                    LOG.info("Retrying " + request.getUrl().toString());
                    return true;
                }
                return false;
            }
        });
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper));
    }
}

