/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.beam.examples.java8.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.examples.java8.repackaged.com.google.common.base.Verify;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class WriteToText<InputT>
extends PTransform<PCollection<InputT>, PDone> {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST")));
    protected String filenamePrefix;
    protected Map<String, FieldFn<InputT>> fieldFn;
    protected boolean windowed;

    public WriteToText() {
    }

    public WriteToText(String filenamePrefix, Map<String, FieldFn<InputT>> fieldFn, boolean windowed) {
        this.filenamePrefix = filenamePrefix;
        this.fieldFn = fieldFn;
        this.windowed = windowed;
    }

    public PDone expand(PCollection<InputT> teamAndScore) {
        if (this.windowed) {
            ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)new WriteOneFilePerWindow(this.filenamePrefix));
        } else {
            ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)TextIO.write().to(this.filenamePrefix));
        }
        return PDone.in((Pipeline)teamAndScore.getPipeline());
    }

    protected static class PerWindowFiles
    extends FileBasedSink.FilenamePolicy {
        private final String prefix;

        public PerWindowFiles(String prefix) {
            this.prefix = prefix;
        }

        public String filenamePrefixForWindow(IntervalWindow window) {
            return String.format("%s-%s-%s", this.prefix, formatter.print((ReadableInstant)window.start()), formatter.print((ReadableInstant)window.end()));
        }

        public ResourceId windowedFilename(ResourceId outputDirectory, FileBasedSink.FilenamePolicy.WindowedContext context, String extension) {
            IntervalWindow window = (IntervalWindow)context.getWindow();
            String filename = String.format("%s-%s-of-%s%s", this.filenamePrefixForWindow(window), context.getShardNumber(), context.getNumShards(), extension);
            return outputDirectory.resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public ResourceId unwindowedFilename(ResourceId outputDirectory, FileBasedSink.FilenamePolicy.Context context, String extension) {
            throw new UnsupportedOperationException("Unsupported.");
        }
    }

    protected class WriteOneFilePerWindow
    extends PTransform<PCollection<String>, PDone> {
        private final String filenamePrefix;

        public WriteOneFilePerWindow(String filenamePrefix) {
            this.filenamePrefix = filenamePrefix;
        }

        public PDone expand(PCollection<String> input) {
            Preconditions.checkArgument(input.getWindowingStrategy().getWindowFn().windowCoder() == IntervalWindow.getCoder());
            String prefix = "";
            ResourceId resource = FileBasedSink.convertToFileResourceIfPossible((String)this.filenamePrefix);
            if (!resource.isDirectory()) {
                prefix = Verify.verifyNotNull(resource.getFilename(), "A non-directory resource should have a non-null filename: %s", resource);
            }
            return (PDone)input.apply((PTransform)TextIO.write().to(resource.getCurrentDirectory()).withFilenamePolicy((FileBasedSink.FilenamePolicy)new PerWindowFiles(prefix)).withWindowedWrites().withNumShards(3));
        }
    }

    protected class BuildRowFn
    extends DoFn<InputT, String> {
        protected BuildRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Map.Entry entry : WriteToText.this.fieldFn.entrySet()) {
                String key = entry.getKey();
                FieldFn fcn = entry.getValue();
                fields.add(key + ": " + fcn.apply(c, window));
            }
            String result = fields.stream().collect(Collectors.joining(", "));
            c.output((Object)result);
        }
    }

    public static interface FieldFn<InputT>
    extends Serializable {
        public Object apply(DoFn.ProcessContext var1, BoundedWindow var2);
    }
}

